/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.struct.geo.AssociatedPair;
import georegression.fitting.MotionTransformPoint;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;

public class GenerateSe2_AssociatedPair
implements ModelGenerator<Se2_F64, AssociatedPair> {
    MotionTransformPoint<Se2_F64, Point2D_F64> estimate;
    List<Point2D_F64> from = new ArrayList<Point2D_F64>();
    List<Point2D_F64> to = new ArrayList<Point2D_F64>();

    public GenerateSe2_AssociatedPair(MotionTransformPoint<Se2_F64, Point2D_F64> estimate) {
        this.estimate = estimate;
    }

    public Se2_F64 createModelInstance() {
        return new Se2_F64();
    }

    public boolean generate(List<AssociatedPair> dataSet, Se2_F64 output) {
        this.from.clear();
        this.to.clear();
        for (int i = 0; i < dataSet.size(); ++i) {
            AssociatedPair p = dataSet.get(i);
            this.from.add(p.getP1());
            this.to.add(p.getP2());
        }
        if (!this.estimate.process(this.from, this.to)) {
            return false;
        }
        output.set((Se2_F64)this.estimate.getMotion());
        return true;
    }

    public int getMinimumPoints() {
        return this.estimate.getMinimumPoints();
    }
}

