/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.alg.geo.pose.PositionFromPairLinear2;
import boofcv.struct.geo.Point2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ejml.data.DenseMatrix64F;

public class TranGivenRotGenerator
implements ModelGenerator<Vector3D_F64, Point2D3D> {
    PositionFromPairLinear2 alg = new PositionFromPairLinear2();
    DenseMatrix64F R;
    List<Point3D_F64> worldPts = new ArrayList<Point3D_F64>();
    List<Point2D_F64> observed = new ArrayList<Point2D_F64>();

    public void setRotation(DenseMatrix64F r) {
        this.R = r;
    }

    public Vector3D_F64 createModelInstance() {
        return new Vector3D_F64();
    }

    public boolean generate(List<Point2D3D> dataSet, Vector3D_F64 model) {
        this.worldPts.clear();
        this.observed.clear();
        for (int i = 0; i < dataSet.size(); ++i) {
            Point2D3D p = dataSet.get(i);
            this.worldPts.add(p.location);
            this.observed.add(p.observation);
        }
        if (this.alg.process(this.R, this.worldPts, this.observed)) {
            model.set(this.alg.getT());
        }
        return true;
    }

    public int getMinimumPoints() {
        return 2;
    }
}

