/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.klt;

import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;

public class PyramidKltTracker<InputImage extends ImageSingleBand, DerivativeImage extends ImageSingleBand> {
    KltTracker<InputImage, DerivativeImage> tracker;
    ImagePyramid<InputImage> image;
    DerivativeImage[] derivX;
    DerivativeImage[] derivY;

    public PyramidKltTracker(KltTracker<InputImage, DerivativeImage> tracker) {
        this.tracker = tracker;
    }

    public void setDescription(PyramidKltFeature feature) {
        int layer = 0;
        while (layer < this.image.getNumLayers()) {
            float scale = (float)this.image.getScale(layer);
            float x = feature.x / scale;
            float y = feature.y / scale;
            this.setupKltTracker(layer);
            feature.desc[layer].setPosition(x, y);
            if (!this.tracker.setDescription(feature.desc[layer])) break;
            feature.maxLayer = layer++;
        }
    }

    public void setImage(ImagePyramid<InputImage> image, DerivativeImage[] derivX, DerivativeImage[] derivY) {
        if (image.getNumLayers() != derivX.length || image.getNumLayers() != derivY.length) {
            throw new IllegalArgumentException("Number of layers does not match.");
        }
        this.image = image;
        this.derivX = derivX;
        this.derivY = derivY;
    }

    public KltTrackFault track(PyramidKltFeature feature) {
        boolean worked = false;
        int firstLevelTracked = -1;
        float x = feature.x;
        float y = feature.y;
        for (int layer = feature.maxLayer; layer >= 0; --layer) {
            float scale = (float)this.image.getScale(layer);
            this.setupKltTracker(layer);
            feature.desc[layer].setPosition(x /= scale, y /= scale);
            KltTrackFault ret = this.tracker.track(feature.desc[layer]);
            if (ret == KltTrackFault.OUT_OF_BOUNDS) {
                x = feature.desc[layer].x;
                y = feature.desc[layer].y;
                feature.maxLayer = layer - 1;
                worked = false;
            } else if (ret == KltTrackFault.SUCCESS) {
                if (firstLevelTracked == -1) {
                    firstLevelTracked = layer;
                }
                x = feature.desc[layer].x;
                y = feature.desc[layer].y;
                worked = true;
            } else {
                return ret;
            }
            x *= scale;
            y *= scale;
        }
        if (worked) {
            feature.setPosition(x, y);
            return KltTrackFault.SUCCESS;
        }
        return KltTrackFault.OUT_OF_BOUNDS;
    }

    private void setupKltTracker(int layer) {
        if (this.derivX != null) {
            this.tracker.setImage((ImageSingleBand)this.image.getLayer(layer), this.derivX[layer], this.derivY[layer]);
        } else {
            this.tracker.setImage((ImageSingleBand)this.image.getLayer(layer), null, null);
        }
    }
}

