/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.PyramidFloat;

public class PyramidFloatGaussianScale<T extends ImageSingleBand>
extends PyramidFloat<T> {
    protected InterpolatePixel<T> interpolate;
    protected T tempImage;
    protected float[] sigmaLayers;
    protected double[] sigma;

    public PyramidFloatGaussianScale(InterpolatePixel<T> interpolate, double[] scales, double[] sigmaLayers, Class<T> imageType) {
        super(imageType, scales);
        int i;
        if (scales.length != sigmaLayers.length) {
            throw new IllegalArgumentException("Number of scales and sigmas must be the same");
        }
        this.interpolate = interpolate;
        this.sigmaLayers = new float[sigmaLayers.length];
        for (i = 0; i < sigmaLayers.length; ++i) {
            this.sigmaLayers[i] = (float)sigmaLayers[i];
        }
        this.sigma = new double[sigmaLayers.length];
        this.sigma[0] = sigmaLayers[0];
        for (i = 1; i < scales.length; ++i) {
            double effectiveSigma = sigmaLayers[i] * scales[i - 1];
            this.sigma[i] = Math.sqrt(this.sigma[i - 1] * this.sigma[i - 1] + effectiveSigma * effectiveSigma);
        }
    }

    @Override
    public void process(T input) {
        super.initialize(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        if (this.isSaveOriginalReference()) {
            throw new IllegalArgumentException("The original reference cannot be saved");
        }
        if (this.tempImage == null) {
            this.tempImage = (ImageSingleBand)((ImageBase)input)._createNew(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
        for (int i = 0; i < this.scale.length; ++i) {
            T prev = i == 0 ? input : this.getLayer(i - 1);
            ImageBase layer = this.getLayer(i);
            BlurStorageFilter<?> blur = FactoryBlurFilter.gaussian(layer.getClass(), this.sigmaLayers[i], -1);
            ((ImageSingleBand)this.tempImage).reshape(((ImageSingleBand)prev).width, ((ImageSingleBand)prev).height);
            blur.process(prev, this.tempImage);
            if (this.scale[i] == 1.0) {
                ((ImageSingleBand)layer).setTo(this.tempImage);
                continue;
            }
            PixelTransformAffine_F32 model = DistortSupport.transformScale(layer, this.tempImage);
            DistortImageOps.distortSingle(this.tempImage, layer, (PixelTransform_F32)model, null, this.interpolate);
        }
    }

    public InterpolatePixel<T> getInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(InterpolatePixel<T> interpolate) {
        this.interpolate = interpolate;
    }

    @Override
    public double getSampleOffset(int layer) {
        return 0.0;
    }

    @Override
    public double getSigma(int layer) {
        return this.sigma[layer];
    }

    public float[] getSigmaLayers() {
        return this.sigmaLayers;
    }
}

