/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.wavelet;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.alg.transform.wavelet.impl.ImplWaveletTransformBorder;
import boofcv.alg.transform.wavelet.impl.ImplWaveletTransformInner;
import boofcv.alg.transform.wavelet.impl.ImplWaveletTransformNaive;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class WaveletTransformOps {
    public static <T extends ImageSingleBand, W extends ImageSingleBand> Class<W> getWaveletType(Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return ImageFloat32.class;
        }
        if (imageType == ImageUInt8.class) {
            return ImageSInt32.class;
        }
        throw new IllegalArgumentException("Unknown type");
    }

    public static void transform1(WaveletDescription<WlCoef_F32> desc, ImageFloat32 input, ImageFloat32 output, ImageFloat32 storage) {
        UtilWavelet.checkShape(input, output);
        WlCoef_F32 coef = desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = InputSanityCheck.checkDeclare(output, storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (input.getWidth() <= minSize || input.getHeight() <= minSize) {
            ImplWaveletTransformNaive.horizontal(desc.getBorder(), coef, input, storage);
            ImplWaveletTransformNaive.vertical(desc.getBorder(), coef, storage, output);
        } else {
            ImplWaveletTransformInner.horizontal(coef, input, storage);
            ImplWaveletTransformBorder.horizontal(desc.getBorder(), coef, input, storage);
            ImplWaveletTransformInner.vertical(coef, storage, output);
            ImplWaveletTransformBorder.vertical(desc.getBorder(), coef, storage, output);
        }
    }

    public static void transformN(WaveletDescription<WlCoef_F32> desc, ImageFloat32 input, ImageFloat32 output, ImageFloat32 storage, int numLevels) {
        if (numLevels == 1) {
            WaveletTransformOps.transform1(desc, input, output, storage);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), input, output, numLevels);
        storage = InputSanityCheck.checkDeclare(output, storage);
        storage = (ImageFloat32)storage.subimage(0, 0, output.width, output.height);
        WaveletTransformOps.transform1(desc, input, output, storage);
        for (int i = 2; i <= numLevels; ++i) {
            int width = output.width / 2;
            int height = output.height / 2;
            width += width % 2;
            height += height % 2;
            input = (ImageFloat32)input.subimage(0, 0, width, height);
            output = (ImageFloat32)output.subimage(0, 0, width, height);
            input.setTo(output);
            storage.reshape(width, height);
            WaveletTransformOps.transform1(desc, input, output, storage);
        }
    }

    public static void inverse1(WaveletDescription<WlCoef_F32> desc, ImageFloat32 input, ImageFloat32 output, ImageFloat32 storage, float minValue, float maxValue) {
        UtilWavelet.checkShape(output, input);
        WlCoef_F32 coef = desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = InputSanityCheck.checkDeclare(input, storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (output.getWidth() <= minSize || output.getHeight() <= minSize) {
            ImplWaveletTransformNaive.verticalInverse(desc.getBorder(), desc.getInverse(), input, storage);
            ImplWaveletTransformNaive.horizontalInverse(desc.getBorder(), desc.getInverse(), storage, output);
        } else {
            ImplWaveletTransformInner.verticalInverse(desc.getInverse().getInnerCoefficients(), input, storage);
            ImplWaveletTransformBorder.verticalInverse(desc.getBorder(), desc.getInverse(), input, storage);
            ImplWaveletTransformInner.horizontalInverse(desc.getInverse().getInnerCoefficients(), storage, output);
            ImplWaveletTransformBorder.horizontalInverse(desc.getBorder(), desc.getInverse(), storage, output);
        }
        if (minValue != -3.4028235E38f && maxValue != Float.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }

    public static void inverseN(WaveletDescription<WlCoef_F32> desc, ImageFloat32 input, ImageFloat32 output, ImageFloat32 storage, int numLevels, float minValue, float maxValue) {
        if (numLevels == 1) {
            WaveletTransformOps.inverse1(desc, input, output, storage, minValue, maxValue);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), output, input, numLevels);
        storage = InputSanityCheck.checkDeclare(input, storage);
        storage = (ImageFloat32)storage.subimage(0, 0, input.width, input.height);
        int scale = UtilWavelet.computeScale(numLevels);
        int width = input.width / scale;
        int height = input.height / scale;
        width += width % 2;
        height += height % 2;
        ImageFloat32 levelIn = (ImageFloat32)input.subimage(0, 0, width, height);
        ImageFloat32 levelOut = (ImageFloat32)output.subimage(0, 0, width, height);
        storage.reshape(width, height);
        WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, -3.4028235E38f, Float.MAX_VALUE);
        for (int i = numLevels - 1; i >= 1; --i) {
            levelIn.setTo(levelOut);
            if (i > 1) {
                width = input.width / (scale /= 2);
                height = input.height / scale;
                width += width % 2;
                height += height % 2;
                storage.reshape(width, height);
                levelIn = (ImageFloat32)input.subimage(0, 0, width, height);
                levelOut = (ImageFloat32)output.subimage(0, 0, width, height);
            } else {
                levelIn = input;
                levelOut = output;
            }
            storage.reshape(levelIn.width, levelIn.height);
            WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, -3.4028235E38f, Float.MAX_VALUE);
        }
        if (minValue != -3.4028235E38f && maxValue != Float.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }

    public static void transform1(WaveletDescription<WlCoef_I32> desc, ImageSInt32 input, ImageSInt32 output, ImageSInt32 storage) {
        UtilWavelet.checkShape(input, output);
        WlCoef_I32 coef = desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = InputSanityCheck.checkDeclare(output, storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (input.getWidth() <= minSize || input.getHeight() <= minSize) {
            ImplWaveletTransformNaive.horizontal(desc.getBorder(), coef, input, storage);
            ImplWaveletTransformNaive.vertical(desc.getBorder(), coef, storage, output);
        } else {
            ImplWaveletTransformInner.horizontal(coef, input, storage);
            ImplWaveletTransformBorder.horizontal(desc.getBorder(), coef, input, storage);
            ImplWaveletTransformInner.vertical(coef, storage, output);
            ImplWaveletTransformBorder.vertical(desc.getBorder(), coef, storage, output);
        }
    }

    public static void transformN(WaveletDescription<WlCoef_I32> desc, ImageSInt32 input, ImageSInt32 output, ImageSInt32 storage, int numLevels) {
        if (numLevels == 1) {
            WaveletTransformOps.transform1(desc, input, output, storage);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), input, output, numLevels);
        storage = InputSanityCheck.checkDeclare(output, storage);
        storage = (ImageSInt32)storage.subimage(0, 0, output.width, output.height);
        WaveletTransformOps.transform1(desc, input, output, storage);
        for (int i = 2; i <= numLevels; ++i) {
            int width = output.width / 2;
            int height = output.height / 2;
            width += width % 2;
            height += height % 2;
            input = (ImageSInt32)input.subimage(0, 0, width, height);
            output = (ImageSInt32)output.subimage(0, 0, width, height);
            input.setTo(output);
            storage.reshape(width, height);
            WaveletTransformOps.transform1(desc, input, output, storage);
        }
    }

    public static void inverse1(WaveletDescription<WlCoef_I32> desc, ImageSInt32 input, ImageSInt32 output, ImageSInt32 storage, int minValue, int maxValue) {
        UtilWavelet.checkShape(output, input);
        WlCoef_I32 coef = desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = InputSanityCheck.checkDeclare(input, storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (output.getWidth() <= minSize || output.getHeight() <= minSize) {
            ImplWaveletTransformNaive.verticalInverse(desc.getBorder(), desc.getInverse(), input, storage);
            ImplWaveletTransformNaive.horizontalInverse(desc.getBorder(), desc.getInverse(), storage, output);
        } else {
            ImplWaveletTransformInner.verticalInverse(desc.getInverse().getInnerCoefficients(), input, storage);
            ImplWaveletTransformBorder.verticalInverse(desc.getBorder(), desc.getInverse(), input, storage);
            ImplWaveletTransformInner.horizontalInverse(desc.getInverse().getInnerCoefficients(), storage, output);
            ImplWaveletTransformBorder.horizontalInverse(desc.getBorder(), desc.getInverse(), storage, output);
        }
        if (minValue != Integer.MIN_VALUE && maxValue != Integer.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }

    public static void inverseN(WaveletDescription<WlCoef_I32> desc, ImageSInt32 input, ImageSInt32 output, ImageSInt32 storage, int numLevels, int minValue, int maxValue) {
        if (numLevels == 1) {
            WaveletTransformOps.inverse1(desc, input, output, storage, minValue, maxValue);
            PixelMath.boundImage(output, minValue, maxValue);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), output, input, numLevels);
        storage = InputSanityCheck.checkDeclare(input, storage);
        storage = (ImageSInt32)storage.subimage(0, 0, input.width, input.height);
        int scale = UtilWavelet.computeScale(numLevels);
        int width = input.width / scale;
        int height = input.height / scale;
        width += width % 2;
        height += height % 2;
        ImageSInt32 levelIn = (ImageSInt32)input.subimage(0, 0, width, height);
        ImageSInt32 levelOut = (ImageSInt32)output.subimage(0, 0, width, height);
        storage.reshape(width, height);
        WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, Integer.MIN_VALUE, Integer.MAX_VALUE);
        for (int i = numLevels - 1; i >= 1; --i) {
            levelIn.setTo(levelOut);
            if (i > 1) {
                width = input.width / (scale /= 2);
                height = input.height / scale;
                width += width % 2;
                height += height % 2;
                storage.reshape(width, height);
                levelIn = (ImageSInt32)input.subimage(0, 0, width, height);
                levelOut = (ImageSInt32)output.subimage(0, 0, width, height);
            } else {
                levelIn = input;
                levelOut = output;
            }
            storage.reshape(levelIn.width, levelIn.height);
            WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, -2147483647, Integer.MAX_VALUE);
        }
        if (minValue != Integer.MIN_VALUE && maxValue != Integer.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }
}

