/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.impl.ImplImageDistortCache_F32;
import boofcv.alg.distort.impl.ImplImageDistortCache_I16;
import boofcv.alg.distort.impl.ImplImageDistortCache_I8;
import boofcv.alg.distort.impl.ImplImageDistortCache_S32;
import boofcv.alg.distort.impl.ImplImageDistort_F32;
import boofcv.alg.distort.impl.ImplImageDistort_I16;
import boofcv.alg.distort.impl.ImplImageDistort_I8;
import boofcv.alg.distort.impl.ImplImageDistort_MS;
import boofcv.alg.distort.impl.ImplImageDistort_S32;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;

public class FactoryDistort {
    public static <T extends ImageSingleBand> ImageDistort<T> distort(InterpolatePixel<T> interp, ImageBorder border, Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return new ImplImageDistort_F32(interp, border);
        }
        if (ImageSInt32.class.isAssignableFrom(imageType)) {
            return new ImplImageDistort_S32<ImageFloat32>(interp, border);
        }
        if (ImageInt16.class.isAssignableFrom(imageType)) {
            return new ImplImageDistort_I16<ImageFloat32>(interp, border);
        }
        if (ImageInt8.class.isAssignableFrom(imageType)) {
            return new ImplImageDistort_I8<ImageFloat32>(interp, border);
        }
        throw new IllegalArgumentException("Image type not supported: " + imageType.getSimpleName());
    }

    public static <T extends ImageSingleBand> ImageDistort<MultiSpectral<T>> distortMS(InterpolatePixel<T> interp, ImageBorder border, Class<T> imageType) {
        ImageDistort<T> distortSingle = FactoryDistort.distort(interp, border, imageType);
        return new ImplImageDistort_MS<T>(distortSingle);
    }

    public static <T extends ImageSingleBand> ImageDistort<T> distortCached(InterpolatePixel<T> interp, ImageBorder border, Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return new ImplImageDistortCache_F32(interp, border);
        }
        if (ImageSInt32.class.isAssignableFrom(imageType)) {
            return new ImplImageDistortCache_S32((InterpolatePixel<ImageSInt32>)interp, border);
        }
        if (ImageInt16.class.isAssignableFrom(imageType)) {
            return new ImplImageDistortCache_I16<ImageFloat32>(interp, border);
        }
        if (ImageInt8.class.isAssignableFrom(imageType)) {
            return new ImplImageDistortCache_I8<ImageFloat32>(interp, border);
        }
        throw new IllegalArgumentException("Image type not supported: " + imageType.getSimpleName());
    }
}

