/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.edge;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.feature.detect.edge.CannyEdgeDynamic;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.ImageSingleBand;

public class FactoryEdgeDetectors {
    public static <T extends ImageSingleBand, D extends ImageSingleBand> CannyEdge<T, D> canny(int blurRadius, boolean saveTrace, boolean dynamicThreshold, Class<T> imageType, Class<D> derivType) {
        BlurStorageFilter<T> blur = FactoryBlurFilter.gaussian(imageType, -1.0, blurRadius);
        ImageGradient<T, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        if (dynamicThreshold) {
            return new CannyEdgeDynamic<T, D>(blur, gradient, saveTrace);
        }
        return new CannyEdge<T, D>(blur, gradient, saveTrace);
    }
}

