/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.pyramid;

import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.transform.pyramid.PyramidDiscreteSampleBlur;
import boofcv.alg.transform.pyramid.PyramidFloatGaussianScale;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.PyramidDiscrete;
import boofcv.struct.pyramid.PyramidFloat;

public class FactoryPyramid {
    public static <T extends ImageSingleBand> PyramidDiscrete<T> discreteGaussian(int[] scaleFactors, double sigma, int radius, boolean saveOriginalReference, Class<T> imageType) {
        Class kernelType = FactoryKernel.getKernelType(imageType, 1);
        Kernel1D kernel = (Kernel1D)FactoryKernelGaussian.gaussian(kernelType, sigma, radius);
        return new PyramidDiscreteSampleBlur<T>(kernel, sigma, imageType, saveOriginalReference, scaleFactors);
    }

    public static <T extends ImageSingleBand> PyramidFloat<T> floatGaussian(double[] scaleFactors, double[] sigmas, Class<T> imageType) {
        InterpolatePixel<T> interp = FactoryInterpolation.bilinearPixel(imageType);
        return new PyramidFloatGaussianScale<T>(interp, scaleFactors, sigmas, imageType);
    }

    public static <T extends ImageSingleBand> PyramidFloat<T> scaleSpacePyramid(double[] scaleSpace, Class<T> imageType) {
        double[] sigmas = new double[scaleSpace.length];
        sigmas[0] = scaleSpace[0];
        for (int i = 1; i < scaleSpace.length; ++i) {
            double c = scaleSpace[i];
            double b = scaleSpace[i - 1];
            sigmas[i] = Math.sqrt(c * c - b * b);
            int n = i;
            sigmas[n] = sigmas[n] / scaleSpace[i - 1];
        }
        return FactoryPyramid.floatGaussian(scaleSpace, sigmas, imageType);
    }

    public static <T extends ImageSingleBand> PyramidFloat<T> scaleSpace(double[] scaleSpace, Class<T> imageType) {
        double[] scaleFactors = new double[scaleSpace.length];
        for (int i = 0; i < scaleSpace.length; ++i) {
            scaleFactors[i] = 1.0;
        }
        double[] sigmas = new double[scaleSpace.length];
        sigmas[0] = scaleSpace[0];
        for (int i = 1; i < scaleSpace.length; ++i) {
            double c = scaleSpace[i];
            double b = scaleSpace[i - 1];
            sigmas[i] = Math.sqrt(c * c - b * b);
        }
        return FactoryPyramid.floatGaussian(scaleFactors, sigmas, imageType);
    }
}

