/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ImagePanel
extends JPanel {
    protected BufferedImage img;
    protected boolean resize = true;

    public ImagePanel(BufferedImage img) {
        this(img, false);
    }

    public ImagePanel(BufferedImage img, boolean resize) {
        this.img = img;
        this.resize = resize;
        this.autoSetPreferredSize();
    }

    public ImagePanel() {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.img != null) {
            if (this.resize) {
                double ratioH;
                double ratioW = (double)this.getWidth() / (double)this.img.getWidth();
                double ratio = Math.min(ratioW, ratioH = (double)this.getHeight() / (double)this.img.getHeight());
                if (ratio >= 1.0) {
                    ratio = 1.0;
                }
                if (ratio == 1.0) {
                    g.drawImage(this.img, 0, 0, this);
                } else {
                    AffineTransform tran = AffineTransform.getScaleInstance(ratio, ratio);
                    g2.drawImage(this.img, tran, null);
                }
            } else {
                g2.drawImage((Image)this.img, 0, 0, this);
            }
        }
    }

    public void setBufferedImage(BufferedImage image) {
        this.img = image;
    }

    public void setBufferedImageSafe(final BufferedImage image) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImagePanel.this.img = image;
                ImagePanel.this.repaint();
            }
        });
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setResize(boolean resize) {
        this.resize = resize;
    }

    public void autoSetPreferredSize() {
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
    }
}

