/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.misc.BoofcvClassLoader;
import boofcv.misc.XStreamAppletVersion;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;
import com.thoughtworks.boofcv.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class BoofMiscOps {
    public static void saveXML(Object o, String fileName) {
        BoofcvClassLoader loader = new BoofcvClassLoader();
        XStreamAppletVersion xstream = new XStreamAppletVersion((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new DomDriver(), loader, null, (ConverterLookup)new DefaultConverterLookup(), null);
        xstream.registerConverter(new JavaBeanConverter(xstream.getMapper()));
        try {
            xstream.toXML(o, new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadXML(String fileName) {
        BoofcvClassLoader loader = new BoofcvClassLoader();
        XStreamAppletVersion xstream = new XStreamAppletVersion((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new DomDriver(), loader, null, (ConverterLookup)new DefaultConverterLookup(), null);
        xstream.registerConverter(new JavaBeanConverter(xstream.getMapper()));
        try {
            return (T)xstream.fromXML(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadXML(Reader r) {
        BoofcvClassLoader loader = new BoofcvClassLoader();
        XStreamAppletVersion xstream = new XStreamAppletVersion((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new DomDriver(), loader, null, (ConverterLookup)new DefaultConverterLookup(), null);
        xstream.registerConverter(new JavaBeanConverter(xstream.getMapper()));
        return (T)xstream.fromXML(r);
    }

    public static String toString(Reader r) {
        char[] buff = new char[1024];
        StringBuilder string = new StringBuilder();
        try {
            int size;
            while ((size = r.read(buff)) >= 0) {
                string.append(buff, 0, size);
            }
            return string.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int countNotZero(int[] a, int size) {
        int ret = 0;
        for (int i = 0; i < size; ++i) {
            if (a[i] == 0) continue;
            ++ret;
        }
        return ret;
    }

    public static double[] convertTo_F64(int[] a) {
        double[] ret = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        return ret;
    }

    public static float[] convertTo_F32(double[] a, float[] ret) {
        if (ret == null) {
            ret = new float[a.length];
        }
        for (int i = 0; i < a.length; ++i) {
            ret[i] = (float)a[i];
        }
        return ret;
    }

    public static int[] convertTo_I32(double[] a, int[] ret) {
        if (ret == null) {
            ret = new int[a.length];
        }
        for (int i = 0; i < a.length; ++i) {
            ret[i] = (int)a[i];
        }
        return ret;
    }

    public static void boundRectangleInside(ImageBase b, ImageRectangle r) {
        if (r.x0 < 0) {
            r.x0 = 0;
        }
        if (r.x1 > b.width) {
            r.x1 = b.width;
        }
        if (r.y0 < 0) {
            r.y0 = 0;
        }
        if (r.y1 > b.height) {
            r.y1 = b.height;
        }
    }

    public static boolean checkInside(ImageBase b, ImageRectangle r) {
        if (r.x0 < 0) {
            return false;
        }
        if (r.x1 > b.width) {
            return false;
        }
        if (r.y0 < 0) {
            return false;
        }
        return r.y1 <= b.height;
    }

    public static boolean checkInside(ImageBase b, int x, int y, int radius) {
        if (x - radius < 0) {
            return false;
        }
        if (x + radius >= b.width) {
            return false;
        }
        if (y - radius < 0) {
            return false;
        }
        return y + radius < b.height;
    }

    public static boolean checkInside(ImageBase b, float x, float y, float radius) {
        if (x - radius < 0.0f) {
            return false;
        }
        if (x + radius > (float)(b.width - 1)) {
            return false;
        }
        if (y - radius < 0.0f) {
            return false;
        }
        return !(y + radius > (float)(b.height - 1));
    }

    public static boolean checkInside(ImageBase b, double x, double y, double radius) {
        if (x - radius < 0.0) {
            return false;
        }
        if (x + radius > (double)(b.width - 1)) {
            return false;
        }
        if (y - radius < 0.0) {
            return false;
        }
        return !(y + radius > (double)(b.height - 1));
    }

    public static boolean checkInside(ImageBase b, int x, int y, int radiusWidth, int radiusHeight) {
        if (x - radiusWidth < 0) {
            return false;
        }
        if (x + radiusWidth >= b.width) {
            return false;
        }
        if (y - radiusHeight < 0) {
            return false;
        }
        return y + radiusHeight < b.height;
    }

    public static boolean checkInside(ImageBase b, int c_x, int c_y, int radius, double theta) {
        float s;
        int r = radius;
        float c = (float)Math.cos(theta);
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, -r, -r, c, s = (float)Math.sin(theta))) {
            return false;
        }
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, -r, r, c, s)) {
            return false;
        }
        if (!BoofMiscOps.checkInBounds(b, c_x, c_y, r, r, c, s)) {
            return false;
        }
        return BoofMiscOps.checkInBounds(b, c_x, c_y, r, -r, c, s);
    }

    private static boolean checkInBounds(ImageBase b, int c_x, int c_y, int dx, int dy, float c, float s) {
        float x = (float)c_x + c * (float)dx - s * (float)dy;
        float y = (float)c_y + s * (float)dx + c * (float)dy;
        return b.isInBounds((int)x, (int)y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(long milli) {
        Thread t = Thread.currentThread();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < milli) {
            Thread thread = t;
            synchronized (thread) {
                try {
                    long target = milli - (System.currentTimeMillis() - start);
                    if (target > 0L) {
                        t.wait(target);
                    }
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
    }

    public static void print(ImageSingleBand a) {
        if (a.getTypeInfo().isInteger()) {
            BoofMiscOps.print((ImageInteger)a);
        } else if (a instanceof ImageFloat32) {
            BoofMiscOps.print((ImageFloat32)a);
        } else {
            BoofMiscOps.print((ImageFloat64)a);
        }
    }

    public static void print(ImageFloat64 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%6.2f ", a.get(x, y));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(ImageFloat32 a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%6.2f ", Float.valueOf(a.get(x, y)));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void print(ImageInteger a) {
        for (int y = 0; y < a.height; ++y) {
            for (int x = 0; x < a.width; ++x) {
                System.out.printf("%4d ", a.get(x, y));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static List<String> directoryList(String directory, String prefix) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        File d = new File(directory);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory");
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden() || !f.getName().contains(prefix)) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }
}

