/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import java.lang.reflect.Array;

public class MultiSpectral<T extends ImageSingleBand>
extends ImageBase<MultiSpectral<T>> {
    public Class<T> type;
    public T[] bands;

    public MultiSpectral(Class<T> type, int width, int height, int numBands) {
        this.type = type;
        this.stride = width;
        this.width = width;
        this.height = height;
        this.bands = (ImageSingleBand[])Array.newInstance(type, numBands);
        for (int i = 0; i < numBands; ++i) {
            this.bands[i] = GeneralizedImageOps.createSingleBand(type, width, height);
        }
    }

    protected MultiSpectral(Class<T> type, int numBands) {
        this.type = type;
        this.bands = (ImageSingleBand[])Array.newInstance(type, numBands);
    }

    public Class<T> getType() {
        return this.type;
    }

    public int getNumBands() {
        return this.bands.length;
    }

    public T getBand(int band) {
        if (band >= this.bands.length || band < 0) {
            throw new IllegalArgumentException("The specified band is out of bounds: " + band);
        }
        return this.bands[band];
    }

    @Override
    public MultiSpectral<T> subimage(int x0, int y0, int x1, int y1) {
        if (x0 < 0 || y0 < 0) {
            throw new IllegalArgumentException("x0 or y0 is less than zero");
        }
        if (x1 < x0 || y1 < y0) {
            throw new IllegalArgumentException("x1 or y1 is less than x0 or y0 respectively");
        }
        if (x1 > this.width || y1 > this.height) {
            throw new IllegalArgumentException("x1 or y1 is more than the width or height respectively");
        }
        MultiSpectral<T> ret = new MultiSpectral<T>(this.type, this.bands.length);
        ret.stride = Math.max(this.width, this.stride);
        ret.width = x1 - x0;
        ret.height = y1 - y0;
        ret.startIndex = this.startIndex + y0 * this.stride + x0;
        for (int i = 0; i < this.bands.length; ++i) {
            ret.bands[i] = ((ImageSingleBand)this.bands[i]).subimage(x0, y0, x1, y1);
        }
        return ret;
    }

    @Override
    public void setTo(MultiSpectral<T> orig) {
        if (orig.width != this.width || orig.height != this.height) {
            throw new IllegalArgumentException("The width and/or height of 'orig' is not the same as this class");
        }
        if (orig.getNumBands() != this.getNumBands()) {
            throw new IllegalArgumentException("The number of bands must be the same");
        }
        if (orig.getType() != this.getType()) {
            throw new IllegalArgumentException("The band type must be the same");
        }
        int N = orig.getNumBands();
        for (int i = 0; i < N; ++i) {
            ((ImageSingleBand)this.bands[i]).setTo(orig.getBand(i));
        }
    }

    @Override
    public void reshape(int width, int height) {
        for (int i = 0; i < this.bands.length; ++i) {
            ((ImageSingleBand)this.bands[i]).reshape(width, height);
        }
        this.startIndex = 0;
        this.stride = width;
        this.width = width;
        this.height = height;
    }

    @Override
    public MultiSpectral<T> _createNew(int imgWidth, int imgHeight) {
        return new MultiSpectral<T>(this.type, imgWidth, imgHeight, this.bands.length);
    }
}

