/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.boofcv.converters.reflection;

import com.thoughtworks.boofcv.core.util.CustomObjectInputStream;
import com.thoughtworks.boofcv.core.util.XStreamClassLoader;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class ExternalizableConverter
implements Converter {
    private Mapper mapper;
    private final XStreamClassLoader classLoader;

    public ExternalizableConverter(Mapper mapper, XStreamClassLoader classLoader) {
        this.mapper = mapper;
        this.classLoader = classLoader;
    }

    public ExternalizableConverter(Mapper mapper) {
        this(mapper, null);
    }

    public boolean canConvert(Class type) {
        return Externalizable.class.isAssignableFrom(type);
    }

    public void marshal(Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        try {
            Externalizable externalizable = (Externalizable)source;
            CustomObjectOutputStream.StreamCallback callback = new CustomObjectOutputStream.StreamCallback(){

                public void writeToStream(Object object) {
                    if (object == null) {
                        writer.startNode("null");
                        writer.endNode();
                    } else {
                        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)ExternalizableConverter.this.mapper.serializedClass(object.getClass()), object.getClass());
                        context.convertAnother(object);
                        writer.endNode();
                    }
                }

                public void writeFieldsToStream(Map fields) {
                    throw new UnsupportedOperationException();
                }

                public void defaultWriteObject() {
                    throw new UnsupportedOperationException();
                }

                public void flush() {
                    writer.flush();
                }

                public void close() {
                    throw new UnsupportedOperationException("Objects are not allowed to call ObjectOutput.close() from writeExternal()");
                }
            };
            CustomObjectOutputStream objectOutput = CustomObjectOutputStream.getInstance((DataHolder)context, (CustomObjectOutputStream.StreamCallback)callback);
            externalizable.writeExternal((ObjectOutput)objectOutput);
            objectOutput.popCallback();
        }
        catch (IOException e) {
            throw new ConversionException("Cannot serialize " + source.getClass().getName() + " using Externalization", (Throwable)e);
        }
    }

    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        Class type = context.getRequiredType();
        try {
            Constructor defaultConstructor = type.getDeclaredConstructor(null);
            if (!defaultConstructor.isAccessible()) {
                defaultConstructor.setAccessible(true);
            }
            final Externalizable externalizable = (Externalizable)defaultConstructor.newInstance(null);
            CustomObjectInputStream.StreamCallback callback = new CustomObjectInputStream.StreamCallback(){

                @Override
                public Object readFromStream() {
                    reader.moveDown();
                    Class type = HierarchicalStreams.readClassType((HierarchicalStreamReader)reader, (Mapper)ExternalizableConverter.this.mapper);
                    Object streamItem = context.convertAnother((Object)externalizable, type);
                    reader.moveUp();
                    return streamItem;
                }

                @Override
                public Map readFieldsFromStream() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void defaultReadObject() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                    throw new NotActiveException("stream inactive");
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException("Objects are not allowed to call ObjectInput.close() from readExternal()");
                }
            };
            CustomObjectInputStream objectInput = CustomObjectInputStream.getInstance((DataHolder)context, callback, this.classLoader);
            externalizable.readExternal(objectInput);
            objectInput.popCallback();
            return externalizable;
        }
        catch (NoSuchMethodException e) {
            throw new ConversionException("Cannot construct " + type.getClass() + ", missing default constructor", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException("Cannot construct " + type.getClass(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConversionException("Cannot construct " + type.getClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Cannot construct " + type.getClass(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ConversionException("Cannot externalize " + type.getClass(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException("Cannot externalize " + type.getClass(), (Throwable)e);
        }
    }
}

