/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.predictions;

import adams.data.weka.predictions.AbstractErrorScaler;
import java.util.ArrayList;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;

public class RoundErrorScaler
extends AbstractErrorScaler {
    private static final long serialVersionUID = -8616657706467047751L;

    public String globalInfo() {
        return "Performs no scaling at all, just rounds the error to the next integer.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllClasses();
        return result;
    }

    @Override
    public ArrayList<Integer> scale(ArrayList data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < data.size(); ++i) {
            if (data.get(i) instanceof Double) {
                result.add((int)Math.round((Double)data.get(i)));
                continue;
            }
            if (data.get(i) instanceof Integer) {
                result.add((int)Math.round(((Integer)data.get(i)).doubleValue()));
                continue;
            }
            result.add(1);
        }
        return result;
    }
}

