/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.CallableSource;
import adams.flow.transformer.AbstractWekaClassifierEvaluator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.core.Instances;

public class WekaTestSetEvaluator
extends AbstractWekaClassifierEvaluator
implements ProvenanceSupporter {
    private static final long serialVersionUID = -8528709957864675275L;
    protected CallableActorReference m_Testset;
    protected boolean m_DiscardPredictions;

    public String globalInfo() {
        return "Evaluates a trained classifier (obtained from input) on the dataset obtained from the callable actor.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("testset", "testset", (Object)new CallableActorReference("Testset"));
        this.m_OptionManager.add("no-predictions", "discardPredictions", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"testset", (Object)this.m_Testset);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"discardPredictions", (boolean)this.m_DiscardPredictions, (String)"discarding predictions", (String)", ");
        return result;
    }

    public void setTestset(CallableActorReference value) {
        this.m_Testset = value;
        this.reset();
    }

    public CallableActorReference getTestset() {
        return this.m_Testset;
    }

    public String testsetTipText() {
        return "The callable actor to use for obtaining the test set.";
    }

    public void setDiscardPredictions(boolean value) {
        this.m_DiscardPredictions = value;
        this.reset();
    }

    public boolean getDiscardPredictions() {
        return this.m_DiscardPredictions;
    }

    public String discardPredictionsTipText() {
        return "If enabled, the collection of predictions during evaluation is suppressed, wich will conserve memory.";
    }

    public Class[] accepts() {
        return new Class[]{Classifier.class, WekaModelContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Instances test = null;
            CallableSource gs = new CallableSource();
            gs.setCallableName(this.m_Testset);
            gs.setParent(this.getParent());
            gs.setUp();
            gs.execute();
            Token output = gs.output();
            if (output != null) {
                test = (Instances)output.getPayload();
            } else {
                result = "No test set available!";
            }
            gs.wrapUp();
            if (result == null) {
                Classifier cls = this.m_InputToken.getPayload() instanceof Classifier ? (Classifier)this.m_InputToken.getPayload() : (Classifier)((WekaModelContainer)((Object)this.m_InputToken.getPayload())).getValue("Model");
                this.m_Output.setHeader(test);
                Evaluation eval = new Evaluation(test);
                eval.setDiscardPredictions(this.m_DiscardPredictions);
                eval.evaluateModel(cls, test, new Object[]{this.m_Output});
                this.m_OutputToken = this.m_Output instanceof Null ? new Token((Object)new WekaEvaluationContainer(eval, cls)) : new Token((Object)this.m_Output.getBuffer().toString());
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to evaluate: ", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

