/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise.genetic.fitnessfunctions;

import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.optimise.AbstractFitnessFunction;
import java.io.FileReader;
import java.io.Reader;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instances;
import weka.core.UnassignedClassException;

public abstract class AbstractWEKAFitnessFunction
extends AbstractFitnessFunction {
    private static final long serialVersionUID = 8593164242546231576L;
    protected Instances m_Instances = null;
    protected PlaceholderFile m_Dataset;
    protected Classifier m_Classifier;
    protected PlaceholderDirectory m_OutputDirectory;
    protected int m_Folds;
    protected int m_CrossValidationSeed;
    protected String m_ClassIndex;
    protected Measure m_Measure;
    protected boolean m_init = false;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("folds", "folds", (Object)10);
        this.m_OptionManager.add("cv-seed", "crossValidationSeed", (Object)55);
        this.m_OptionManager.add("classifier", "classifier", (Object)new ZeroR());
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("dataset", "dataset", (Object)new PlaceholderFile("./data.arff"));
        this.m_OptionManager.add("class", "classIndex", (Object)"last");
        this.m_OptionManager.add("measure", "measure", (Object)Measure.RMSE);
    }

    public void setFolds(int value) {
        this.m_Folds = value;
        this.reset();
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in cross-validation.";
    }

    public void setCrossValidationSeed(int value) {
        this.m_CrossValidationSeed = value;
        this.reset();
    }

    public int getCrossValidationSeed() {
        return this.m_CrossValidationSeed;
    }

    public String crossValidationSeedTipText() {
        return "The seed value for cross-validation.";
    }

    public void setInstances(Instances value) {
        this.m_Instances = value;
        this.reset();
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setDataset(PlaceholderFile value) {
        this.m_Dataset = value;
        this.reset();
    }

    public PlaceholderFile getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset to use for cross-validation.";
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use if no serialized is supplied.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory for storing the generated ARFF files.";
    }

    public void setClassIndex(String value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public String getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The class index of the dataset ('first' and 'last' are accepted as well).";
    }

    public void setMeasure(Measure value) {
        this.m_Measure = value;
        this.reset();
    }

    public Measure getMeasure() {
        return this.m_Measure;
    }

    public String measureTipText() {
        return "The measure used for evaluating the fitness.";
    }

    public String globalInfo() {
        return "WEKA Fitness";
    }

    protected synchronized void init() {
        int classIndex = 0;
        if (!this.m_init) {
            try {
                FileReader reader = new FileReader(this.m_Dataset.getAbsolutePath());
                this.m_Instances = new Instances((Reader)reader);
                reader.close();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to read instances: " + this.m_Dataset, e);
                throw new IllegalStateException("Error loading dataset '" + this.m_Dataset + "': " + e);
            }
            classIndex = this.m_ClassIndex.equals("first") ? 0 : (this.m_ClassIndex.equals("last") ? this.m_Instances.numAttributes() - 1 : Integer.parseInt(this.m_ClassIndex));
            this.m_Instances.setClassIndex(classIndex);
            this.m_init = true;
        }
    }

    public static enum Measure {
        CC(false, false, true),
        RMSE(true, true, true),
        RRSE(true, true, true),
        MAE(true, true, true),
        RAE(true, true, true),
        ACC(false, true, false);

        private boolean m_Negative;
        private boolean m_Nominal;
        private boolean m_Numeric;

        private Measure(boolean negative, boolean nominal, boolean numeric) {
            this.m_Negative = negative;
            this.m_Nominal = nominal;
            this.m_Numeric = numeric;
        }

        public double adjust(double measure) {
            if (this.m_Negative) {
                return -measure;
            }
            return measure;
        }

        public boolean isValid(Instances data) {
            if (data.classIndex() == -1) {
                throw new UnassignedClassException("No class attribute set!");
            }
            if (data.classAttribute().isNominal()) {
                return this.m_Nominal;
            }
            if (data.classAttribute().isNumeric()) {
                return this.m_Numeric;
            }
            throw new IllegalStateException("Class attribute '" + data.classAttribute().type() + "' not handled!");
        }
    }
}

