/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import adams.core.option.OptionUtils;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

public class PLSClassifierWeighted
extends AbstractClassifier
implements WeightedInstancesHandler {
    private static final long serialVersionUID = 4819775160590973256L;
    protected PLSFilter m_Filter = this.getDefaultFilter();
    protected PLSFilter m_ActualFilter = null;

    public String globalInfo() {
        return "A wrapper classifier for the PLSFilter, utilizing the PLSFilter's ability to perform predictions.";
    }

    public PLSFilter getDefaultFilter() {
        return new PLSFilter();
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe PLS filter to use. Full classname of filter to include, \tfollowed by scheme options.\n\t(default: " + this.getDefaultFilter().getClass().getName() + ")", "filter", 1, "-filter <filter specification>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        if (this.getFilter() instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-filter'):"));
            en = ((OptionHandler)this.getFilter()).listOptions();
            while (en.hasMoreElements()) {
                result.addElement(en.nextElement());
            }
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-filter");
        if (this.getFilter() instanceof OptionHandler) {
            result.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions((String[])((OptionHandler)this.getFilter()).getOptions()));
        } else {
            result.add(this.getFilter().getClass().getName());
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((String)"filter", (String[])options);
        String[] tmpOptions = Utils.splitOptions((String)tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setFilter((Filter)OptionUtils.forName(Filter.class, (String)tmpStr, (String[])tmpOptions));
        } else {
            this.setFilter((Filter)this.getDefaultFilter());
        }
    }

    public String filterTipText() {
        return "The PLS filter to be used (only used for setup).";
    }

    public void setFilter(Filter value) throws Exception {
        if (!(value instanceof PLSFilter)) {
            throw new Exception("Filter has to be PLSFilter!");
        }
        this.m_Filter = (PLSFilter)value;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getFilter().getCapabilities();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_ActualFilter = (PLSFilter)Filter.makeCopy((Filter)this.m_Filter);
        this.m_ActualFilter.setPerformPrediction(false);
        this.m_ActualFilter.setInputFormat(data);
        Filter.useFilter((Instances)data, (Filter)this.m_ActualFilter);
        this.m_ActualFilter.setPerformPrediction(true);
    }

    public double classifyInstance(Instance instance) throws Exception {
        this.m_ActualFilter.input(instance);
        this.m_ActualFilter.batchFinished();
        Instance pred = this.m_ActualFilter.output();
        double result = pred.classValue();
        return result;
    }

    public String toString() {
        String result = ((Object)((Object)this)).getClass().getName() + "\n" + ((Object)((Object)this)).getClass().getName().replaceAll(".", "=") + "\n\n";
        result = result + "# Components..........: " + this.m_Filter.getNumComponents() + "\n";
        result = result + "Algorithm.............: " + this.m_Filter.getAlgorithm().getSelectedTag().getReadable() + "\n";
        result = result + "Replace missing values: " + (this.m_Filter.getReplaceMissing() ? "yes" : "no") + "\n";
        result = result + "Preprocessing.........: " + this.m_Filter.getPreprocessing().getSelectedTag().getReadable() + "\n";
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 7212 $");
    }

    public static void main(String[] args) {
        PLSClassifierWeighted.runClassifier((Classifier)new PLSClassifierWeighted(), (String[])args);
    }
}

