/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.GaussianProcesses;
import weka.classifiers.lazy.LWL;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class LWLSynchro
extends LWL {
    static final long serialVersionUID = 1979797405383665815L;
    protected boolean m_NoUpdate;

    public LWLSynchro() {
        this.m_Classifier = new GaussianProcesses();
    }

    protected String defaultClassifierString() {
        return GaussianProcesses.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tSuppresses the update of the nearest neighbor search (nns)\n\talgorithm with the data that is to be classified.\n(default: nns gets updated).\n", "no-update", 0, "-no-update"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setNoUpdate(Utils.getFlag((String)"no-update", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getNoUpdate()) {
            result.add("-no-update");
        }
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public String noUpdateTipText() {
        return "If turned on, suppresses the update of the nearest-neighbor search algorithm when making predictions (EXPERIMENTAL).";
    }

    public void setNoUpdate(boolean value) {
        this.m_NoUpdate = value;
    }

    public boolean getNoUpdate() {
        return this.m_NoUpdate;
    }

    protected void build(Instance instance) throws Exception {
        int i;
        int i2;
        double bandwidth;
        if (!this.m_NoUpdate) {
            this.m_NNSearch.addInstanceInfo(instance);
        }
        int k = this.m_Train.numInstances();
        if (!this.m_UseAllK && this.m_kNN < k) {
            k = this.m_kNN;
        }
        Instances neighbours = this.m_NNSearch.kNearestNeighbours(instance, k);
        double[] distances = this.m_NNSearch.getDistances();
        if (this.m_Debug) {
            System.out.println("Test Instance: " + instance);
            System.out.println("For " + k + " kept " + neighbours.numInstances() + " out of " + this.m_Train.numInstances() + " instances.");
        }
        if (k > distances.length) {
            k = distances.length;
        }
        if (this.m_Debug) {
            System.out.println("Instance Distances");
            for (int i3 = 0; i3 < distances.length; ++i3) {
                System.out.println("" + distances[i3]);
            }
        }
        if ((bandwidth = distances[k - 1]) <= 0.0) {
            for (i2 = 0; i2 < distances.length; ++i2) {
                distances[i2] = 1.0;
            }
        } else {
            for (i2 = 0; i2 < distances.length; ++i2) {
                distances[i2] = distances[i2] / bandwidth;
            }
        }
        block11: for (i2 = 0; i2 < distances.length; ++i2) {
            switch (this.m_WeightKernel) {
                case 0: {
                    distances[i2] = 1.0001 - distances[i2];
                    continue block11;
                }
                case 1: {
                    distances[i2] = 0.75 * (1.0001 - distances[i2] * distances[i2]);
                    continue block11;
                }
                case 2: {
                    distances[i2] = Math.pow(1.0001 - Math.pow(distances[i2], 3.0), 3.0);
                    continue block11;
                }
                case 5: {
                    distances[i2] = 1.0;
                    continue block11;
                }
                case 3: {
                    distances[i2] = 1.0 / (1.0 + distances[i2]);
                    continue block11;
                }
                case 4: {
                    distances[i2] = Math.exp(-distances[i2] * distances[i2]);
                }
            }
        }
        if (this.m_Debug) {
            System.out.println("Instance Weights");
            for (i2 = 0; i2 < distances.length; ++i2) {
                System.out.println("" + distances[i2]);
            }
        }
        double sumOfWeights = 0.0;
        double newSumOfWeights = 0.0;
        for (i = 0; i < distances.length; ++i) {
            double weight = distances[i];
            Instance inst = neighbours.instance(i);
            sumOfWeights += inst.weight();
            newSumOfWeights += inst.weight() * weight;
            inst.setWeight(inst.weight() * weight);
        }
        for (i = 0; i < neighbours.numInstances(); ++i) {
            Instance inst = neighbours.instance(i);
            inst.setWeight(inst.weight() * sumOfWeights / newSumOfWeights);
        }
        this.m_Classifier.buildClassifier(neighbours);
    }

    public synchronized double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        if (this.m_Train.numInstances() == 0) {
            throw new Exception("No training instances!");
        }
        this.build(instance);
        if (this.m_Debug) {
            System.out.println("Classifying test instance: " + instance);
            System.out.println("Built base classifier:\n" + this.m_Classifier.toString());
        }
        return this.m_Classifier.distributionForInstance(instance);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        if (this.m_Train != null && result.indexOf("neighbours") > -1) {
            result.append("\n# of training instances: " + this.m_Train.numInstances() + "\n");
        }
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 5670 $");
    }

    public static void main(String[] argv) {
        LWLSynchro.runClassifier((Classifier)new LWLSynchro(), (String[])argv);
    }
}

