/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesYAxisPanelOptions;
import adams.gui.visualization.timeseries.TimeseriesPanel;
import java.awt.Container;

public class DefaultTimeseriesYAxisPanelOptions
extends AbstractTimeseriesYAxisPanelOptions {
    private static final long serialVersionUID = -1774995113138870653L;
    protected boolean m_Fixed;
    protected double m_Minimum;
    protected double m_Maximum;

    public String globalInfo() {
        return "Encapsulates options for the Y axis in a timeseries plot.\nIt is possible to fix the range of the Y axis.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("fixed", "fixed", (Object)false);
        this.m_OptionManager.add("minimum", "minimum", (Object)0.0);
        this.m_OptionManager.add("maximum", "maximum", (Object)1.0);
    }

    public void setFixed(boolean value) {
        this.m_Fixed = value;
        this.reset();
    }

    public boolean getFixed() {
        return this.m_Fixed;
    }

    public String fixedTipText() {
        return "If enabled, fixed minimum/maximum are used for the axis.";
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum for the axis, if fixed.";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum for the axis, if fixed.";
    }

    public void configure(PlotPanel plot, Axis axis) {
        super.configure(plot, axis);
        Object parent = GUIHelper.getParent((Container)plot, TimeseriesPanel.class);
        if (parent != null) {
            TimeseriesPanel panel = (TimeseriesPanel)((Object)parent);
            if (this.m_Fixed) {
                panel.setMinY(this.m_Minimum);
                panel.setMaxY(this.m_Maximum);
            } else {
                panel.setMinY(null);
                panel.setMaxY(null);
            }
        }
    }
}

