/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.SurfFeature;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;

public class WrapDescribeSurf<T extends ImageSingleBand, II extends ImageSingleBand>
implements DescribeRegionPoint<T, SurfFeature> {
    DescribePointSurf<II> surf;
    II ii;
    ImageType<T> imageType;

    public WrapDescribeSurf(DescribePointSurf<II> surf, Class<T> imageType) {
        this.surf = surf;
        this.imageType = ImageType.single(imageType);
    }

    @Override
    public SurfFeature createDescription() {
        return new SurfFeature(this.surf.getDescriptionLength());
    }

    @Override
    public void setImage(T image) {
        if (this.ii != null) {
            this.ii.reshape(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
        }
        this.ii = GIntegralImageOps.transform(image, this.ii);
        this.surf.setImage(this.ii);
    }

    @Override
    public boolean process(double x, double y, double orientation, double scale, SurfFeature storage) {
        this.surf.describe(x, y, orientation, scale, storage);
        return true;
    }

    @Override
    public boolean requiresScale() {
        return true;
    }

    @Override
    public boolean requiresOrientation() {
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public Class<SurfFeature> getDescriptionType() {
        return SurfFeature.class;
    }
}

