/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.util;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LZFFileInputStream
extends FileInputStream {
    protected final ChunkDecoder _decompressor;
    protected final BufferRecycler _recycler;
    protected boolean _inputStreamClosed;
    protected boolean _cfgFullReads = false;
    protected byte[] _inputBuffer;
    protected byte[] _decodedBytes;
    protected int _bufferPosition = 0;
    protected int _bufferLength = 0;
    protected final Wrapper _wrapper;

    public LZFFileInputStream(File file) throws FileNotFoundException {
        this(file, ChunkDecoderFactory.optimalInstance());
    }

    public LZFFileInputStream(FileDescriptor fdObj) {
        this(fdObj, ChunkDecoderFactory.optimalInstance());
    }

    public LZFFileInputStream(String name) throws FileNotFoundException {
        this(name, ChunkDecoderFactory.optimalInstance());
    }

    public LZFFileInputStream(File file, ChunkDecoder decompressor) throws FileNotFoundException {
        super(file);
        this._decompressor = decompressor;
        this._recycler = BufferRecycler.instance();
        this._inputStreamClosed = false;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public LZFFileInputStream(FileDescriptor fdObj, ChunkDecoder decompressor) {
        super(fdObj);
        this._decompressor = decompressor;
        this._recycler = BufferRecycler.instance();
        this._inputStreamClosed = false;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public LZFFileInputStream(String name, ChunkDecoder decompressor) throws FileNotFoundException {
        super(name);
        this._decompressor = decompressor;
        this._recycler = BufferRecycler.instance();
        this._inputStreamClosed = false;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public void setUseFullReads(boolean b) {
        this._cfgFullReads = b;
    }

    public int available() {
        if (this._inputStreamClosed) {
            return -1;
        }
        int left = this._bufferLength - this._bufferPosition;
        return left <= 0 ? 0 : left;
    }

    public void close() throws IOException {
        this._bufferLength = 0;
        this._bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        if (!this._inputStreamClosed) {
            this._inputStreamClosed = true;
            super.close();
        }
    }

    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this._decodedBytes[this._bufferPosition++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        if (length < 1) {
            return 0;
        }
        int chunkLength = Math.min(this._bufferLength - this._bufferPosition, length);
        System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
        this._bufferPosition += chunkLength;
        if (chunkLength == length || !this._cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this._bufferLength - this._bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
            this._bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    public long skip(long n) throws IOException {
        if (!this.readyBuffer()) {
            return -1L;
        }
        int left = this._bufferLength - this._bufferPosition;
        if ((long)left > n) {
            left = (int)n;
        }
        this._bufferPosition += left;
        return left;
    }

    public int readAndWrite(OutputStream out) throws IOException {
        int total = 0;
        while (this.readyBuffer()) {
            int avail = this._bufferLength - this._bufferPosition;
            out.write(this._decodedBytes, this._bufferPosition, avail);
            this._bufferPosition += avail;
            total += avail;
        }
        return total;
    }

    protected boolean readyBuffer() throws IOException {
        if (this._inputStreamClosed) {
            throw new IOException("Input stream closed");
        }
        if (this._bufferPosition < this._bufferLength) {
            return true;
        }
        this._bufferLength = this._decompressor.decodeChunk(this._wrapper, this._inputBuffer, this._decodedBytes);
        if (this._bufferLength < 0) {
            return false;
        }
        this._bufferPosition = 0;
        return this._bufferPosition < this._bufferLength;
    }

    protected final int readRaw(byte[] buffer, int offset, int length) throws IOException {
        return super.read(buffer, offset, length);
    }

    private final class Wrapper
    extends InputStream {
        private Wrapper() {
        }

        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return LZFFileInputStream.this.readRaw(buffer, offset, length);
        }
    }
}

