/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F64;

public abstract class GeoTuple2D_F64<T extends GeoTuple2D_F64>
extends GeoTuple_F64<T> {
    public double x;
    public double y;

    public GeoTuple2D_F64(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public GeoTuple2D_F64() {
    }

    protected void _set(GeoTuple2D_F64 a) {
        this.x = a.x;
        this.y = a.y;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean isIdentical(double x, double y) {
        return this.x == x && this.y == y;
    }

    public boolean isIdentical(double x, double y, double tol) {
        return Math.abs(this.x - x) < tol && Math.abs(this.y - y) < tol;
    }

    @Override
    public boolean isIdentical(T t, double tol) {
        return Math.abs(this.x - ((GeoTuple2D_F64)t).x) < tol && Math.abs(this.y - ((GeoTuple2D_F64)t).y) < tol;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void plusIP(GeoTuple2D_F64 a) {
        this.x += a.x;
        this.y += a.y;
    }

    public T plus(GeoTuple2D_F64 a) {
        GeoTuple2D_F64 ret = (GeoTuple2D_F64)this.createNewInstance();
        ret.x = this.x + a.x;
        ret.y = this.y + a.y;
        return (T)ret;
    }

    public void timesIP(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
    }

    public void scale(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
    }

    public T times(double scalar) {
        GeoTuple2D_F64 ret = (GeoTuple2D_F64)this.createNewInstance();
        ret.x = this.x * scalar;
        ret.y = this.y * scalar;
        return (T)ret;
    }

    @Override
    public double distance(T t) {
        double dx = ((GeoTuple2D_F64)t).x - this.x;
        double dy = ((GeoTuple2D_F64)t).y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public double distance2(T t) {
        double dx = ((GeoTuple2D_F64)t).x - this.x;
        double dy = ((GeoTuple2D_F64)t).y - this.y;
        return dx * dx + dy * dy;
    }

    @Override
    public double getIndex(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIndex(int index, double value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public double normSq() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    public void print() {
        System.out.println(this);
    }
}

