/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import moa.AbstractMOAObject;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Regressor;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.FIMTDDNumericAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NullAttributeClassObserver;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.classifiers.core.splitcriteria.VarianceReductionSplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.options.ClassOption;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.options.MultiChoiceOption;
import weka.core.Instance;

public class ORTO
extends AbstractClassifier
implements Regressor {
    private static final long serialVersionUID = 1L;
    protected Node treeRoot;
    private int leafNodeCount = 0;
    private int innerNodeCount = 0;
    private int optionNodeCount = 0;
    private int numTrees = 1;
    protected int maxDepth = 0;
    protected double inactiveLeafByteSizeEstimate;
    protected double activeLeafByteSizeEstimate;
    protected double byteSizeEstimateOverheadFraction;
    protected ArrayList<InnerNode> nodesToAdapt = new ArrayList();
    protected boolean Adaptable = true;
    protected double initLearnRate = 0.1;
    protected double learnRateDecay = 0.001;
    public int maxID = 0;
    private double learnTime = 0.0;
    private double predictTime = 0.0;
    public FloatOption PageHinckleyAlphaOption = new FloatOption("PageHinckleyAlpha", 'a', "The alpha value to use in the Page Hinckley change detection tests.", 0.005, 0.0, 1.0);
    public IntOption PageHinckleyThresholdOption = new IntOption("PageHinckleyThreshold", 'h', "The threshold value to be used in the Page Hinckley change detection tests.", 50, 0, Integer.MAX_VALUE);
    public FloatOption AlternateTreeFadingFactorOption = new FloatOption("AlternateTreeFadingFactor", 'f', "The fading factor to use when deciding if an alternate tree should replace an original.", 0.995, 0.0, 1.0);
    public IntOption AlternateTreeTMinOption = new IntOption("AlternateTreeTMin", 'y', "The Tmin value to use when deciding if an alternate tree should replace an original.", 150, 0, Integer.MAX_VALUE);
    public IntOption AlternateTreeTimeOption = new IntOption("AlternateTreeTime", 'u', "The 'time' (in terms of number of instances) value to use when deciding if an alternate tree should be discarded.", 1500, 0, Integer.MAX_VALUE);
    public FloatOption LearningRatioOption = new FloatOption("LearningRatio", 'w', "Learning ratio to use for training the Perceptrons in the leaves.", 0.01, 0.0, 1.0);
    public FlagOption LearningRatioDecayOrConstOption = new FlagOption("LearningRatioDecayOrConst", 'j', "learning Ratio Decay or const parameter.");
    public IntOption MaxTreesOption = new IntOption("MaxTrees", 'm', "The maximum number of trees contained in the option tree.", 10, 1, Integer.MAX_VALUE);
    public IntOption MaxOptionLevelOption = new IntOption("MaxOptionLevel", 'l', "The maximal depth at which option nodes can be created.", 10, 0, Integer.MAX_VALUE);
    public FloatOption OptionDecayFactorOption = new FloatOption("OptionDecayFactor", 'd', "The option decay factor that determines how many options can be selected at a given level.", 0.9, 0.0, 1.0);
    public ClassOption splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", VarianceReductionSplitCriterion.class, "VarianceReductionSplitCriterion");
    public ClassOption numericEstimatorOption = new ClassOption("numericEstimator", 'n', "Numeric estimator to use.", FIMTDDNumericAttributeClassObserver.class, "FIMTDDNumericAttributeClassObserver");
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FlagOption removePoorAttsOption = new FlagOption("removePoorAtts", 'p', "Disable poor attributes.");
    public MultiChoiceOption OptionNodeAggregationOption = new MultiChoiceOption("OptionNodeAggregation", 'o', "The aggregation method used to combine predictions in option nodes.", new String[]{"average", "bestTree"}, new String[]{"Average", "Best tree"}, 0);
    public FloatOption OptionFadingFactorOption = new FloatOption("OptionFadingFactor", 'q', "The fading factor used for comparing subtrees of an option node.", 0.9995, 0.0, 1.0);

    @Override
    public String getPurposeString() {
        return "Implementation of the ORTO tree as described by Ikonomovska et al.";
    }

    public ORTO() {
        this.splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", VarianceReductionSplitCriterion.class, "VarianceReductionSplitCriterion");
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        this.numTrees = 1;
        this.innerNodeCount = 0;
        this.leafNodeCount = 0;
        this.optionNodeCount = 0;
        this.maxID = 0;
        this.learnTime = 0.0;
        this.predictTime = 0.0;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    protected void checkRoot() {
        if (this.treeRoot == null) {
            ++this.maxID;
            this.treeRoot = new ActiveLearningNode(this.maxID);
            this.leafNodeCount = 1;
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("number of subtrees", this.numTrees), new Measurement("tree size (nodes)", this.leafNodeCount + this.innerNodeCount), new Measurement("tree size (leaves)", this.leafNodeCount), new Measurement("number of option nodes", this.optionNodeCount)};
    }

    public int calcByteSize() {
        int size = (int)SizeOf.sizeOf(this);
        if (this.treeRoot != null) {
            size += this.treeRoot.calcByteSize();
        }
        return size;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot != null) {
            double start = System.nanoTime();
            double[] out = new double[]{this.treeRoot.getPrediction(inst, this)[0]};
            this.predictTime += (double)System.nanoTime() - start;
            return out;
        }
        return new double[0];
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        double start = System.nanoTime();
        this.checkRoot();
        this.treeRoot.processInstance(inst, this);
        for (InnerNode node : this.nodesToAdapt) {
            if (!node.Adaptable) continue;
            ++this.maxID;
            node.alternateTree = new ActiveLearningNode(this.maxID);
            node.alternateTree.Adaptable = false;
            node.alternateTree.Alternate = true;
            node.alternateTree.alternateTree = node;
            node.setAdaptable(false);
            node.lossStatistics.setValue(0, 0.0);
            node.lossStatistics.setValue(1, 0.0);
            node.lossStatistics.setValue(2, 0.0);
            node.PHmT = 0.0;
            node.PHMT = Double.MAX_VALUE;
            node.weightSeen = 0;
            node.previousWeight = 0;
        }
        this.nodesToAdapt = new ArrayList();
        this.learnTime += (double)System.nanoTime() - start;
    }

    protected AttributeClassObserver newNumericClassObserver() {
        AttributeClassObserver numericClassObserver = (AttributeClassObserver)this.getPreparedClassOption(this.numericEstimatorOption);
        return numericClassObserver;
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    protected Node findWorstOption() {
        Stack<Node> stack = new Stack<Node>();
        stack.add(this.treeRoot);
        double ratio = Double.MIN_VALUE;
        Node out = null;
        while (!stack.empty()) {
            int myIndex;
            OptionNode myParent;
            double myRatio;
            Node node = (Node)stack.pop();
            if (node.parent instanceof OptionNode && (myRatio = (myParent = (OptionNode)node.parent).getFFRatio(myIndex = myParent.getChildIndex(node))) > ratio) {
                ratio = myRatio;
                out = node;
            }
            if (!(node instanceof InnerNode)) continue;
            for (Node child : ((InnerNode)node).children) {
                stack.add(child);
            }
        }
        return out;
    }

    protected void removeExcessTrees() {
        while (this.numTrees > this.MaxTreesOption.getValue()) {
            Node option = this.findWorstOption();
            OptionNode parent = (OptionNode)option.parent;
            int index = parent.getChildIndex(option);
            if (parent.children.size() == 2) {
                parent.children.remove(index);
                for (Node chld : parent.children) {
                    chld.parent = parent.parent;
                    parent.parent.setChild(parent.parent.getChildIndex(parent), chld);
                }
            } else {
                AutoExpandVector<Node> children = new AutoExpandVector<Node>();
                double[] optionFFSSL = new double[parent.children.size() - 1];
                double[] optionFFSeen = new double[parent.children.size() - 1];
                int seen = 0;
                for (int i = 0; i < parent.children.size() - 1; ++i) {
                    if (parent.getChild(i) != option) {
                        children.add(parent.getChild(i));
                        optionFFSSL[i] = parent.optionFFSSL[i + seen];
                        optionFFSeen[i] = parent.optionFFSeen[i + seen];
                        continue;
                    }
                    seen = 1;
                }
                parent.children = children;
                parent.optionFFSSL = optionFFSSL;
                parent.optionFFSeen = optionFFSeen;
                assert (parent.children.size() == parent.optionFFSSL.length);
            }
            --this.numTrees;
        }
    }

    public static class ORTOPerceptron
    extends AbstractMOAObject {
        private static final long serialVersionUID = 1L;
        protected double[] weightAttribute;
        protected DoubleVector attributeStatistics = new DoubleVector();
        protected DoubleVector squaredAttributeStatistics = new DoubleVector();
        protected int instancesSeen = 0;
        protected boolean reset;

        @Override
        public void getDescription(StringBuilder sb, int indent) {
        }

        public ORTOPerceptron(ORTOPerceptron copy) {
            this.weightAttribute = copy.getWeights();
        }

        public ORTOPerceptron() {
            this.reset = true;
        }

        public void setWeights(double[] w) {
            this.weightAttribute = w;
        }

        public double[] getWeights() {
            return this.weightAttribute;
        }

        public void resetLearningImpl() {
            this.reset = true;
        }

        public void trainOnInstanceImpl(Instance inst, ORTO ft) {
            int j;
            if (this.reset) {
                this.reset = false;
                this.weightAttribute = new double[inst.numAttributes()];
                this.instancesSeen = 0;
                this.attributeStatistics = new DoubleVector();
                this.squaredAttributeStatistics = new DoubleVector();
                for (j = 0; j < inst.numAttributes(); ++j) {
                    this.weightAttribute[j] = 2.0 * ft.classifierRandom.nextDouble() - 1.0;
                }
            }
            ++this.instancesSeen;
            for (j = 0; j < inst.numAttributes() - 1; ++j) {
                this.attributeStatistics.addToValue(j, inst.value(j));
                this.squaredAttributeStatistics.addToValue(j, inst.value(j) * inst.value(j));
            }
            double learningRatio = 0.0;
            learningRatio = ft.LearningRatioDecayOrConstOption.isSet() ? ft.LearningRatioOption.getValue() : ft.initLearnRate / (1.0 + (double)this.instancesSeen * ft.learnRateDecay);
            double actualClass = inst.classValue();
            double predictedClass = this.prediction(inst);
            double delta = actualClass - predictedClass;
            for (int j2 = 0; j2 < inst.numAttributes() - 1; ++j2) {
                if (!inst.attribute(j2).isNumeric()) continue;
                double sd = Math.sqrt((this.squaredAttributeStatistics.getValue(j2) - this.attributeStatistics.getValue(j2) * this.attributeStatistics.getValue(j2) / (double)this.instancesSeen) / (double)this.instancesSeen);
                double instanceValue = 0.0;
                if (sd > 1.0E-7) {
                    instanceValue = (inst.value(j2) - this.attributeStatistics.getValue(j2) / (double)this.instancesSeen) / (3.0 * sd);
                }
                int n = j2;
                this.weightAttribute[n] = this.weightAttribute[n] + learningRatio * delta * instanceValue;
            }
            int n = inst.numAttributes() - 1;
            this.weightAttribute[n] = this.weightAttribute[n] + learningRatio * delta;
        }

        public double prediction(Instance inst) {
            double prediction = 0.0;
            if (!this.reset) {
                for (int j = 0; j < inst.numAttributes() - 1; ++j) {
                    if (!inst.attribute(j).isNumeric()) continue;
                    prediction += this.weightAttribute[j] * inst.value(j);
                }
                prediction += this.weightAttribute[inst.numAttributes() - 1];
            }
            return (double)Math.round(prediction * 1000.0) / 1000.0;
        }
    }

    public static class ActiveLearningNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public ORTOPerceptron learningModel = new ORTOPerceptron();
        protected DoubleVector nodeStatistics = new DoubleVector();
        protected DoubleVector splitRatioStatistics = new DoubleVector();
        protected double PHmT = 0.0;
        protected double PHMT = Double.MAX_VALUE;
        protected int examplesSeenAtLastSplitEvaluation;
        protected int examplesSeen = 0;
        protected AutoExpandVector<AttributeClassObserver> attributeObservers = new AutoExpandVector();

        public ActiveLearningNode(int id) {
            super(id);
            this.learningModel = new ORTOPerceptron();
        }

        @Override
        public int calcByteSize() {
            return super.calcByteSize() + (int)SizeOf.fullSizeOf(this.attributeObservers) + (int)SizeOf.fullSizeOf(this.learningModel);
        }

        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion, ORTO tree) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] nodeSplitDist = this.nodeStatistics.getArrayCopy();
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null) continue;
                AttributeSplitSuggestion bestSuggestion = null;
                if (obs instanceof FIMTDDNumericAttributeClassObserver) {
                    bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, nodeSplitDist, i, true);
                }
                if (bestSuggestion == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        public void disableAttribute(int attIndex) {
            this.attributeObservers.set(attIndex, new NullAttributeClassObserver());
        }

        public double getPHError(Instance inst) {
            double sd = Math.sqrt((this.nodeStatistics.getValue(2) - this.nodeStatistics.getValue(1) * this.nodeStatistics.getValue(1) / this.nodeStatistics.getValue(1)) / (double)this.examplesSeen);
            double mean = this.nodeStatistics.getValue(2) / this.nodeStatistics.getValue(1);
            return Math.abs((inst.classValue() - this.learningModel.prediction(inst)) / sd) - (this.nodeStatistics.getValue(3) + Math.abs((inst.classValue() - mean) / sd - (this.learningModel.prediction(inst) - mean) / sd)) / (this.nodeStatistics.getValue(1) + 1.0);
        }

        public double getSquaredError() {
            return this.nodeStatistics.getValue(4);
        }

        public double getError(Instance inst) {
            return inst.classValue() - this.learningModel.prediction(inst);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double[] processInstance(Instance inst, ORTO tree) {
            double prediction = this.getPrediction(inst, tree)[0];
            ++this.examplesSeen;
            this.nodeStatistics.addToValue(0, 1.0);
            this.nodeStatistics.addToValue(2, inst.classValue() * inst.classValue());
            double sd = Math.sqrt((this.nodeStatistics.getValue(2) - this.nodeStatistics.getValue(1) * this.nodeStatistics.getValue(1) / (double)this.examplesSeen) / (double)this.examplesSeen);
            double error = this.getError(inst);
            this.nodeStatistics.addToValue(3, Math.abs(error / sd));
            this.nodeStatistics.setValue(4, this.nodeStatistics.getValue(4) * tree.AlternateTreeFadingFactorOption.getValue() + error * error);
            double ph = this.getPHError(inst);
            this.learningModel.trainOnInstanceImpl(inst, tree);
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = ORTO.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null && inst.attribute(instAttIndex).isNumeric()) {
                    obs = tree.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                if (obs == null) continue;
                ((FIMTDDNumericAttributeClassObserver)obs).observeAttributeClass(inst.value(instAttIndex), inst.classValue(), inst.weight());
            }
            if (this.examplesSeen - this.examplesSeenAtLastSplitEvaluation >= tree.gracePeriodOption.getValue()) {
                SplitCriterion splitCriterion = (SplitCriterion)tree.getPreparedClassOption(tree.splitCriterionOption);
                Object[] bestSplitSuggestions = this.getBestSplitSuggestions(splitCriterion, tree);
                LinkedList<Object> acceptedSplits = new LinkedList<Object>();
                Arrays.sort(bestSplitSuggestions);
                int numSplits = 0;
                if (bestSplitSuggestions.length == 1) {
                    numSplits = 1;
                    acceptedSplits.add(bestSplitSuggestions[0]);
                } else if (bestSplitSuggestions.length > 1) {
                    double hoeffdingBound = ORTO.computeHoeffdingBound(1.0, tree.splitConfidenceOption.getValue(), this.examplesSeen);
                    Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                    Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
                    if (((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit < 1.0 - hoeffdingBound) {
                        numSplits = 1;
                        acceptedSplits.add(bestSuggestion);
                    } else if (tree.numTrees < tree.MaxTreesOption.getValue() && this.getLevel() <= tree.MaxOptionLevelOption.getValue()) {
                        for (Object suggestion : bestSplitSuggestions) {
                            if (!(((AttributeSplitSuggestion)suggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit >= 1.0 - hoeffdingBound)) continue;
                            ++numSplits;
                            acceptedSplits.add(suggestion);
                        }
                    } else if (hoeffdingBound < tree.tieThresholdOption.getValue()) {
                        numSplits = 1;
                        acceptedSplits.add(bestSplitSuggestions[0]);
                    } else {
                        for (int i = 0; i < this.attributeObservers.size(); ++i) {
                            AttributeClassObserver attributeClassObserver = this.attributeObservers.get(i);
                            if (attributeClassObserver == null) continue;
                            ((FIMTDDNumericAttributeClassObserver)attributeClassObserver).removeBadSplits(splitCriterion, ((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit, ((AttributeSplitSuggestion)bestSuggestion).merit, hoeffdingBound);
                        }
                    }
                    if (tree.removePoorAttsOption != null && tree.removePoorAttsOption.isSet()) {
                        void var20_25;
                        void var20_23;
                        HashSet<Integer> poorAtts = new HashSet<Integer>();
                        boolean bl = false;
                        while (var20_23 < bestSplitSuggestions.length) {
                            int[] splitAtts;
                            if (((AttributeSplitSuggestion)bestSplitSuggestions[var20_23]).splitTest != null && (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[var20_23]).splitTest.getAttsTestDependsOn()).length == 1 && ((AttributeSplitSuggestion)bestSuggestion).merit / ((AttributeSplitSuggestion)secondBestSuggestion).merit + hoeffdingBound < 1.0) {
                                poorAtts.add(new Integer(splitAtts[0]));
                            }
                            ++var20_23;
                        }
                        boolean bl2 = false;
                        while (var20_25 < bestSplitSuggestions.length) {
                            int[] splitAtts;
                            if (((AttributeSplitSuggestion)bestSplitSuggestions[var20_25]).splitTest != null && (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[var20_25]).splitTest.getAttsTestDependsOn()).length == 1 && ((AttributeSplitSuggestion)bestSuggestion).merit / ((AttributeSplitSuggestion)secondBestSuggestion).merit + hoeffdingBound < 1.0) {
                                poorAtts.remove(new Integer(splitAtts[0]));
                            }
                            ++var20_25;
                        }
                        Iterator iterator = poorAtts.iterator();
                        while (iterator.hasNext()) {
                            int poorAtt = (Integer)iterator.next();
                            this.disableAttribute(poorAtt);
                        }
                    }
                }
                if (numSplits > 0) {
                    double optionFactor = (double)numSplits * Math.pow(tree.OptionDecayFactorOption.getValue(), this.getLevel());
                    if (numSplits == 1 || optionFactor < 2.0 || tree.MaxTreesOption.getValue() - tree.numTrees <= 1) {
                        AttributeSplitSuggestion splitDecision = (AttributeSplitSuggestion)acceptedSplits.get(0);
                        ++tree.maxID;
                        SplitNode newSplit = new SplitNode(splitDecision.splitTest, tree.maxID);
                        newSplit.Adaptable = this.Adaptable;
                        for (int i = 0; i < splitDecision.numSplits(); ++i) {
                            ++tree.maxID;
                            ActiveLearningNode activeLearningNode = new ActiveLearningNode(tree.maxID);
                            activeLearningNode.setParent(newSplit);
                            activeLearningNode.Adaptable = this.Adaptable;
                            newSplit.setChild(i, activeLearningNode);
                        }
                        tree.leafNodeCount--;
                        tree.innerNodeCount++;
                        tree.leafNodeCount += splitDecision.numSplits();
                        if (this.parent == null) {
                            tree.treeRoot = newSplit;
                        } else {
                            this.parent.setChild(this.parent.getChildIndex(this), newSplit);
                            newSplit.setParent(this.parent);
                        }
                    } else {
                        ++tree.maxID;
                        OptionNode optionNode = new OptionNode(tree.maxID);
                        optionNode.Adaptable = this.Adaptable;
                        tree.leafNodeCount--;
                        int j = 0;
                        for (AttributeSplitSuggestion attributeSplitSuggestion : acceptedSplits) {
                            if ((double)j > optionFactor || tree.MaxTreesOption.getValue() - tree.numTrees <= 0) break;
                            ++tree.maxID;
                            SplitNode newSplit = new SplitNode(attributeSplitSuggestion.splitTest, tree.maxID);
                            newSplit.Adaptable = this.Adaptable;
                            for (int i = 0; i < attributeSplitSuggestion.numSplits(); ++i) {
                                ++tree.maxID;
                                ActiveLearningNode newChild = new ActiveLearningNode(tree.maxID);
                                newChild.setParent(newSplit);
                                newSplit.setChild(i, newChild);
                                newChild.Adaptable = this.Adaptable;
                            }
                            tree.leafNodeCount += attributeSplitSuggestion.numSplits();
                            tree.innerNodeCount++;
                            tree.numTrees++;
                            newSplit.setParent(optionNode);
                            optionNode.setChild(j, newSplit);
                            ++j;
                        }
                        tree.innerNodeCount++;
                        tree.optionNodeCount++;
                        if (this.parent == null) {
                            tree.treeRoot = optionNode;
                        } else {
                            this.parent.setChild(this.parent.getChildIndex(this), optionNode);
                            optionNode.setParent(this.parent);
                        }
                        optionNode.resetFF();
                    }
                }
                this.examplesSeenAtLastSplitEvaluation = this.examplesSeen;
            }
            return new double[]{prediction, this.nodeStatistics.getValue(4), this.examplesSeen, ph};
        }

        @Override
        public double[] getPrediction(Instance inst, ORTO tree) {
            return new double[]{this.learningModel.prediction(inst), this.nodeStatistics.getValue(4), this.examplesSeen};
        }
    }

    public static class OptionNode
    extends InnerNode {
        private static final long serialVersionUID = 1L;
        protected double[] optionFFSSL;
        protected double[] optionFFSeen;

        public OptionNode(int id) {
            super(id);
        }

        public void resetFF() {
            this.optionFFSSL = new double[this.children.size()];
            this.optionFFSeen = new double[this.children.size()];
            for (int i = 0; i < this.children.size(); ++i) {
                this.optionFFSSL[i] = 0.0;
                this.optionFFSeen[i] = 0.0;
            }
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getNumSubtrees() {
            int num = 0;
            for (Node child : this.children) {
                num += child.getNumSubtrees();
            }
            return num;
        }

        public int directionForBestTree() {
            int d = 0;
            double tmp = 0.0;
            double min = Double.MAX_VALUE;
            for (int i = 0; i < this.children.size(); ++i) {
                tmp = this.optionFFSSL[i] / this.optionFFSeen[i];
                if (!(tmp < min)) continue;
                min = tmp;
                d = i;
            }
            return d;
        }

        @Override
        public double[] getPrediction(Instance inst, ORTO tree) {
            double[][] predictions = new double[this.children.size()][];
            if (tree.OptionNodeAggregationOption.getChosenIndex() != 1) {
                int i = 0;
                for (i = 0; i < this.children.size(); ++i) {
                    predictions[i] = this.getChild(i).getPrediction(inst, tree);
                }
                return this.aggregate(predictions, tree);
            }
            int d = this.directionForBestTree();
            return this.getChild(d).getPrediction(inst, tree);
        }

        @Override
        public double[] processInstance(Instance inst, ORTO tree) {
            double[][] processed = new double[this.numChildren()][];
            int i = 0;
            for (i = 0; i < this.numChildren(); ++i) {
                processed[i] = this.getChild(i).processInstance(inst, tree);
            }
            double[] prediction = tree.OptionNodeAggregationOption.getChosenIndex() != 1 ? this.aggregate(processed, tree) : processed[this.directionForBestTree()];
            if (this.Adaptable) {
                if (this.alternateTree == null) {
                    double PHerror = inst.classValue() - prediction[0];
                    if (this.PageHinckleyTest(PHerror, tree.PageHinckleyThresholdOption.getValue())) {
                        for (Node node : tree.nodesToAdapt) {
                            if (!this.children.contains(node)) continue;
                            tree.nodesToAdapt.remove(node);
                        }
                        tree.nodesToAdapt.add(this);
                    }
                } else {
                    double[] predictionAlt = this.alternateTree.processInstance(inst, tree);
                    double qOrg = prediction[1];
                    double d = predictionAlt[1];
                    double Qi = Math.log(qOrg / d);
                    this.lossStatistics.addToValue(0, 1.0);
                    this.lossStatistics.addToValue(1, Qi);
                    double QiAverage = this.lossStatistics.getValue(1) / this.lossStatistics.getValue(0);
                    if (this.weightSeen - this.previousWeight >= tree.AlternateTreeTMinOption.getValue()) {
                        this.previousWeight = this.weightSeen;
                        if (Qi > 0.0) {
                            this.alternateTree.setAdaptable(true);
                            this.alternateTree.Alternate = false;
                            if (this.parent != null) {
                                this.parent.setChild(this.parent.getChildIndex(this), this.alternateTree);
                                tree.numTrees = tree.numTrees - this.getNumSubtrees() + this.alternateTree.getNumSubtrees();
                                this.alternateTree.setParent(this.parent);
                                this.alternateTree = null;
                            } else {
                                tree.treeRoot = this.alternateTree;
                                tree.numTrees = tree.numTrees - this.getNumSubtrees() + this.alternateTree.getNumSubtrees();
                                tree.Adaptable = true;
                                this.alternateTree = null;
                            }
                            tree.removeExcessTrees();
                        } else if (QiAverage < this.lossStatistics.getValue(2) && this.lossStatistics.getValue(0) >= (double)(10 * tree.AlternateTreeTMinOption.getValue()) || this.weightSeen >= tree.AlternateTreeTimeOption.getValue()) {
                            this.alternateTree = null;
                            this.setAdaptable(true);
                        }
                        this.lossStatistics.setValue(2, QiAverage);
                    }
                }
                if (this.weightSeen + 1 > tree.gracePeriodOption.getValue() + 50) {
                    for (i = 0; i < this.children.size(); ++i) {
                        double sqLoss = Math.pow(processed[i][0] - inst.classValue(), 2.0);
                        this.optionFFSSL[i] = this.optionFFSSL[i] * tree.OptionFadingFactorOption.getValue() + sqLoss;
                        this.optionFFSeen[i] = this.optionFFSeen[i] * tree.OptionFadingFactorOption.getValue() + 1.0;
                    }
                }
            }
            ++this.weightSeen;
            return prediction;
        }

        private double[] aggregate(double[][] predictions, ORTO tree) {
            if (tree.OptionNodeAggregationOption.getChosenIndex() == 0) {
                int i;
                double[] average = new double[predictions[0].length];
                for (i = 0; i < predictions[0].length; ++i) {
                    average[i] = 0.0;
                }
                for (i = 0; i < predictions[0].length; ++i) {
                    for (int j = 0; j < predictions.length; ++j) {
                        int n = i;
                        average[n] = average[n] + predictions[j][i];
                    }
                    average[i] = average[i] / (double)predictions.length;
                }
                return average;
            }
            assert (false) : tree.OptionNodeAggregationOption.getChosenLabel();
            return new double[]{0.0};
        }

        public double getFFRatio(int childIndex) {
            return this.optionFFSSL[childIndex] / this.optionFFSeen[childIndex];
        }
    }

    public static class SplitNode
    extends InnerNode {
        private static final long serialVersionUID = 1L;
        protected InstanceConditionalTest splitTest;

        @Override
        public void setChild(int index, Node child) {
            if (this.splitTest.maxBranches() >= 0 && index >= this.splitTest.maxBranches()) {
                throw new IndexOutOfBoundsException();
            }
            this.children.set(index, child);
        }

        public SplitNode(InstanceConditionalTest splitTest, int id) {
            super(id);
            this.splitTest = splitTest;
        }

        public int instanceChildIndex(Instance inst) {
            return this.splitTest.branchForInstance(inst);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getNumSubtrees() {
            int num = 1;
            for (Node child : this.children) {
                num += child.getNumSubtrees();
            }
            return num -= this.children.size();
        }

        @Override
        public double[] processInstance(Instance inst, ORTO tree) {
            int branch = this.splitTest.branchForInstance(inst);
            Node child = (Node)this.children.get(branch);
            if (child == null) {
                ++tree.maxID;
                child = new ActiveLearningNode(tree.maxID);
                this.setChild(branch, child);
                child.setParent(this);
            }
            double[] processed = child.processInstance(inst, tree);
            ++this.weightSeen;
            if (this.Adaptable) {
                if (this.alternateTree == null) {
                    double PHerror = processed[3] - tree.PageHinckleyAlphaOption.getValue();
                    if (this.PageHinckleyTest(PHerror, tree.PageHinckleyThresholdOption.getValue())) {
                        if (tree.nodesToAdapt.contains(child)) {
                            tree.nodesToAdapt.remove(child);
                        }
                        tree.nodesToAdapt.add(this);
                    }
                } else if (this.alternateTree != null) {
                    double[] processedAlt = this.alternateTree.processInstance(inst, tree);
                    double qAlt = processedAlt[1];
                    double qOrg = processed[1];
                    double Qi = Math.log(qOrg / qAlt);
                    this.lossStatistics.addToValue(0, 1.0);
                    this.lossStatistics.addToValue(1, Qi);
                    double QiAverage = this.lossStatistics.getValue(1) / this.lossStatistics.getValue(0);
                    if (this.weightSeen - this.previousWeight >= tree.AlternateTreeTMinOption.getValue()) {
                        this.previousWeight = this.weightSeen;
                        if (Qi > 0.0) {
                            this.alternateTree.setAdaptable(true);
                            this.alternateTree.Alternate = false;
                            if (this.parent != null) {
                                this.parent.setChild(this.parent.getChildIndex(this), this.alternateTree);
                                this.alternateTree.setParent(this.parent);
                                tree.numTrees = tree.numTrees - this.getNumSubtrees() + this.alternateTree.getNumSubtrees();
                                this.alternateTree.alternateTree = null;
                            } else {
                                tree.numTrees = tree.numTrees - this.getNumSubtrees() + this.alternateTree.getNumSubtrees();
                                tree.treeRoot = this.alternateTree;
                                this.alternateTree.alternateTree = null;
                            }
                            tree.removeExcessTrees();
                        } else if (QiAverage < this.lossStatistics.getValue(2) && this.lossStatistics.getValue(0) >= (double)(10 * tree.AlternateTreeTMinOption.getValue()) || this.weightSeen >= tree.AlternateTreeTimeOption.getValue()) {
                            this.alternateTree = null;
                            this.setAdaptable(true);
                        }
                        this.lossStatistics.setValue(2, QiAverage);
                    }
                }
            }
            return processed;
        }

        @Override
        public double[] getPrediction(Instance inst, ORTO tree) {
            int branch = this.splitTest.branchForInstance(inst);
            Node child = (Node)this.children.get(branch);
            if (child == null) {
                ++tree.maxID;
                child = new ActiveLearningNode(tree.maxID);
                this.setChild(branch, child);
                child.setParent(this);
            }
            return child.getPrediction(inst, tree);
        }
    }

    public static abstract class InnerNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected AutoExpandVector<Node> children = new AutoExpandVector();
        protected double PHmT = 0.0;
        protected double PHMT = Double.MAX_VALUE;
        protected DoubleVector lossStatistics = new DoubleVector();
        protected int weightSeen = 0;
        protected int previousWeight = 0;

        public InnerNode(int id) {
            super(id);
        }

        public int numChildren() {
            return this.children.size();
        }

        public Node getChild(int index) {
            return this.children.get(index);
        }

        @Override
        public int getChildIndex(Node child) {
            return this.children.indexOf(child);
        }

        @Override
        public void setChild(int index, Node child) {
            this.children.set(index, child);
        }

        public void setAlternateTree(Node tree) {
            this.alternateTree = tree;
        }

        public Node getAlternateTree() {
            return this.alternateTree;
        }

        @Override
        public int calcByteSize() {
            return (int)SizeOf.fullSizeOf(this) + (int)SizeOf.fullSizeOf(this.children);
        }

        @Override
        public void calculateDetph(ORTO tree) {
            if (this.getLevel() > tree.maxDepth) {
                tree.maxDepth = this.getLevel();
            }
            for (Node child : this.children) {
                child.calculateDetph(tree);
            }
        }

        public boolean PageHinckleyTest(double error, double threshold) {
            this.PHmT += error;
            if (this.PHmT < this.PHMT) {
                this.PHMT = this.PHmT;
            }
            return this.PHmT - this.PHMT > threshold;
        }

        @Override
        public void setAdaptable(boolean value) {
            this.Adaptable = value;
            for (Node child : this.children) {
                child.setAdaptable(value);
            }
        }

        @Override
        public void setAlternate(boolean value) {
            this.Alternate = value;
            for (Node child : this.children) {
                child.setAlternate(value);
            }
        }
    }

    public static abstract class Node
    extends AbstractMOAObject {
        private static final long serialVersionUID = 1L;
        public int ID;
        protected InnerNode parent;
        protected Node alternateTree;
        protected boolean Alternate = false;
        protected boolean Adaptable = true;

        public Node(int id) {
            this.ID = id;
        }

        @Override
        public void getDescription(StringBuilder sb, int indent) {
        }

        public int calcByteSize() {
            return (int)SizeOf.fullSizeOf(this);
        }

        public boolean isLeaf() {
            return true;
        }

        public void calculateDetph(ORTO tree) {
            int level = this.getLevel();
            if (level > tree.maxDepth) {
                tree.maxDepth = level;
            }
        }

        public int getLevel() {
            InnerNode target = this.getParent();
            while (target instanceof OptionNode) {
                target = target.getParent();
            }
            if (target == null) {
                if (!this.Alternate) {
                    return 0;
                }
                return this.alternateTree.getLevel();
            }
            return target.getLevel() + 1;
        }

        public void setParent(InnerNode parent) {
            this.parent = parent;
        }

        public InnerNode getParent() {
            return this.parent;
        }

        public void setChild(int parentBranch, Node node) {
        }

        public int getChildIndex(Node child) {
            return 0;
        }

        public int getNumSubtrees() {
            return 1;
        }

        public double[] processInstance(Instance inst, ORTO tree) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }

        public double[] getPrediction(Instance inst, ORTO tree) {
            return new double[]{0.0, 0.0, 0.0};
        }

        public void setAdaptable(boolean value) {
            this.Adaptable = value;
        }

        public void setAlternate(boolean value) {
            this.Alternate = value;
        }
    }
}

