/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import moa.core.InstancesHeader;
import moa.streams.filters.AbstractStreamFilter;
import weka.core.Instance;
import weka.core.Instances;

public class CacheFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1L;
    protected Instances cache;
    protected int indexCache;
    protected int totalCacheInstances;
    protected boolean isInitialized;

    @Override
    public String getPurposeString() {
        return "Stores a dataset in memory.";
    }

    @Override
    protected void restartImpl() {
        this.isInitialized = false;
        if (this.inputStream != null) {
            this.init();
        }
    }

    protected void init() {
        this.cache = new Instances((Instances)this.inputStream.getHeader(), 0);
        this.indexCache = 0;
        this.totalCacheInstances = 0;
        while (this.inputStream.hasMoreInstances()) {
            this.cache.add(this.inputStream.nextInstance());
            ++this.totalCacheInstances;
        }
        this.isInitialized = true;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public Instance nextInstance() {
        Instance inst = null;
        if (this.hasMoreInstances()) {
            inst = this.cache.get(this.indexCache);
            ++this.indexCache;
        }
        return inst;
    }

    @Override
    public boolean hasMoreInstances() {
        return this.indexCache < this.totalCacheInstances;
    }

    @Override
    public long estimatedRemainingInstances() {
        return this.totalCacheInstances - this.indexCache;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

