/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.RProjectHelper;
import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.core.management.LoggingObjectOutputPrinter;
import adams.core.management.OS;
import adams.core.management.OutputProcessStream;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;
import java.util.logging.Level;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class Rserve
extends AbstractStandalone {
    private static final long serialVersionUID = 3708758302541394633L;
    protected String m_Host;
    protected int m_Port;
    protected RConnection m_Connection;
    protected boolean m_Shutdown;

    public String globalInfo() {
        return "Establishes a connection to the Rserve server.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)RProjectHelper.getSingleton().getRserveHost());
        this.m_OptionManager.add("port", "port", (Object)RProjectHelper.getSingleton().getRservePort(), (Number)0, (Number)65535);
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host the Rserve server is running on.";
    }

    public void setPort(int value) {
        this.m_Port = value;
        this.reset();
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port the Rserve server is listening on.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)this.m_Host, (String)"host: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)", port: ");
        return result;
    }

    public RConnection newConnection() {
        try {
            return new RConnection(this.m_Host, this.m_Port);
        }
        catch (Exception e) {
            this.handleException("Failed to create new connection (" + this.m_Host + ":" + this.m_Port + ")", e);
            return null;
        }
    }

    public void closeConnection(RConnection conn) {
        if (conn != null) {
            if (this.m_Shutdown) {
                try {
                    this.getLogger().info("Shutting down Rserve");
                    conn.shutdown();
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Error shutting down Rserve server", e);
                }
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = super.setUp();
        if (result == null) {
            this.m_Shutdown = false;
            this.m_Connection = null;
            boolean connected = false;
            try {
                this.getLogger().info("Trying to connect to existing Rserve (" + this.m_Host + ":" + this.m_Port + ")");
                this.m_Connection = new RConnection(this.m_Host, this.m_Port);
                if (!this.m_Connection.isConnected()) {
                    throw new RserveException(this.m_Connection, "is not connected (" + this.m_Host + ":" + this.m_Port + ")");
                }
                connected = this.m_Connection.isConnected();
                this.getLogger().info("Running Rserve found (" + this.m_Host + ":" + this.m_Port + ")");
            }
            catch (RserveException e) {
                this.getLogger().info("No running Rserve found (" + this.m_Host + ":" + this.m_Port + ")");
                Object[] cmd = new String[]{RProjectHelper.getSingleton().getRExecutable().getAbsolutePath(), "-e", "library(Rserve);Rserve(FALSE,args='--no-save --slave --RS-port " + this.m_Port + "')", "--no-save", "--slave"};
                try {
                    this.getLogger().info("Starting Rserve on port " + this.m_Port + ": " + Utils.flatten((Object[])cmd, (String)" "));
                    Process process = Runtime.getRuntime().exec((String[])cmd);
                    OutputProcessStream stdout = new OutputProcessStream(process, LoggingObjectOutputPrinter.class, true);
                    OutputProcessStream stderr = new OutputProcessStream(process, LoggingObjectOutputPrinter.class, false);
                    ((LoggingObjectOutputPrinter)stdout.getPrinter()).setOwner((LoggingObject)this);
                    ((LoggingObjectOutputPrinter)stderr.getPrinter()).setOwner((LoggingObject)this);
                    new Thread((Runnable)stdout).start();
                    new Thread((Runnable)stderr).start();
                    if (!OS.isWindows()) {
                        this.getLogger().info("Not Windows");
                        int exitValue = process.waitFor();
                        this.getLogger().info("Exit code: " + exitValue);
                        if (exitValue == 0) {
                            this.m_Connection = new RConnection(this.m_Host, this.m_Port);
                            connected = this.m_Connection.isConnected();
                            this.m_Shutdown = true;
                        }
                    } else {
                        this.getLogger().info("Windows");
                        connected = false;
                        for (int i = 0; i < 5; ++i) {
                            this.getLogger().info("Waiting for Rserve to become available #" + (i + 1));
                            if (this.m_Stopped) break;
                            try {
                                Rserve rserve = this;
                                synchronized (rserve) {
                                    ((Object)((Object)this)).wait(500L);
                                    this.m_Connection = new RConnection(this.m_Host, this.m_Port);
                                    connected = this.m_Connection.isConnected();
                                    this.m_Shutdown = true;
                                }
                                if (!connected) continue;
                                break;
                            }
                            catch (Exception ex) {
                                connected = false;
                                this.getLogger().log(Level.SEVERE, "Attempt #" + (i + 1) + " for Rserve to become available:", ex);
                            }
                        }
                    }
                    if (!connected) {
                        result = "Rserve may not be installed properly!\nCommand-line used: " + Utils.flatten((Object[])cmd, (String)" ");
                    }
                }
                catch (Exception e2) {
                    result = this.handleException("Failed to start Rserve server!", e2);
                }
            }
        }
        if (this.m_Connection != null) {
            this.m_Connection.close();
            this.m_Connection = null;
        }
        return result;
    }
}

