/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontAliasMap;
import de.intarsys.cwt.font.FontEnvironment;
import de.intarsys.cwt.font.FontFontMap;
import de.intarsys.cwt.font.FontMapper;
import de.intarsys.cwt.font.FontRegistry;
import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontQuery;

public class FontTools {
    public static String createCanonicalName(IFont iFont) {
        return FontTools.createCanonicalName(iFont.getFontFamilyName(), iFont.getFontStyle().getId());
    }

    public static String createCanonicalName(String string, String string2) {
        return String.valueOf(string.replaceAll("\\s", "")) + "," + string2;
    }

    public static String getFontFamilyName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(45);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static FontStyle getFontStyle(String string) {
        if (string == null) {
            return FontStyle.REGULAR;
        }
        int n = string.indexOf(45);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return FontStyle.getFontStyle(string);
    }

    public static IFont lookupFont(IFontQuery iFontQuery) {
        IFont iFont = FontTools.lookupFontOrMap(iFontQuery);
        if (iFont == null && FontEnvironment.get().registerUserFonts()) {
            iFont = FontTools.lookupFontOrMap(iFontQuery);
        }
        if (iFont == null && FontEnvironment.get().registerSystemFonts()) {
            iFont = FontTools.lookupFontOrMap(iFontQuery);
        }
        return iFont;
    }

    protected static IFont lookupFontOrMap(IFontQuery iFontQuery) {
        IFont iFont = FontRegistry.get().lookupFont(iFontQuery);
        if (iFont == null && (iFont = FontMapper.get().lookupFont(iFontQuery.getFontName())) != null) {
            String string = iFontQuery.getFontType();
            String string2 = iFont.getFontType();
            if (string != null && string2 != null && !"Any".equals(string) && !string2.equals(string)) {
                iFont = null;
            }
        }
        return iFont;
    }

    public static void mapAlias(String string, String string2) {
        FontAliasMap fontAliasMap = new FontAliasMap(FontMapper.get(), string, string2);
        FontMapper.get().registerFontMap(fontAliasMap);
    }

    public static void mapFont(String string, IFont iFont) {
        FontFontMap fontFontMap = new FontFontMap(FontMapper.get(), string, iFont);
        FontMapper.get().registerFontMap(fontFontMap);
    }
}

