/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.fcth;

import net.semanticmetadata.lire.imageanalysis.fcth.FuzzyRules;

public class Fuzzy10Bin {
    public boolean KeepPreviuesValues = false;
    protected double[] HueMembershipValues = new double[]{0.0, 0.0, 5.0, 10.0, 5.0, 10.0, 35.0, 50.0, 35.0, 50.0, 70.0, 85.0, 70.0, 85.0, 150.0, 165.0, 150.0, 165.0, 195.0, 205.0, 195.0, 205.0, 265.0, 280.0, 265.0, 280.0, 315.0, 330.0, 315.0, 330.0, 360.0, 360.0};
    protected double[] SaturationMembershipValues = new double[]{0.0, 0.0, 10.0, 75.0, 10.0, 75.0, 255.0, 255.0};
    protected double[] ValueMembershipValues = new double[]{0.0, 0.0, 10.0, 75.0, 10.0, 75.0, 180.0, 220.0, 180.0, 220.0, 255.0, 255.0};
    public FuzzyRules[] Fuzzy10BinRules = new FuzzyRules[48];
    public double[] Fuzzy10BinHisto = new double[10];
    public double[] HueActivation = new double[8];
    public double[] SaturationActivation = new double[2];
    public double[] ValueActivation = new double[3];
    public int[][] Fuzzy10BinRulesDefinition = new int[][]{{0, 0, 0, 2}, {0, 1, 0, 2}, {0, 0, 2, 0}, {0, 0, 1, 1}, {1, 0, 0, 2}, {1, 1, 0, 2}, {1, 0, 2, 0}, {1, 0, 1, 1}, {2, 0, 0, 2}, {2, 1, 0, 2}, {2, 0, 2, 0}, {2, 0, 1, 1}, {3, 0, 0, 2}, {3, 1, 0, 2}, {3, 0, 2, 0}, {3, 0, 1, 1}, {4, 0, 0, 2}, {4, 1, 0, 2}, {4, 0, 2, 0}, {4, 0, 1, 1}, {5, 0, 0, 2}, {5, 1, 0, 2}, {5, 0, 2, 0}, {5, 0, 1, 1}, {6, 0, 0, 2}, {6, 1, 0, 2}, {6, 0, 2, 0}, {6, 0, 1, 1}, {7, 0, 0, 2}, {7, 1, 0, 2}, {7, 0, 2, 0}, {7, 0, 1, 1}, {0, 1, 1, 3}, {0, 1, 2, 3}, {1, 1, 1, 4}, {1, 1, 2, 4}, {2, 1, 1, 5}, {2, 1, 2, 5}, {3, 1, 1, 6}, {3, 1, 2, 6}, {4, 1, 1, 7}, {4, 1, 2, 7}, {5, 1, 1, 8}, {5, 1, 2, 8}, {6, 1, 1, 9}, {6, 1, 2, 9}, {7, 1, 1, 3}, {7, 1, 2, 3}};

    public Fuzzy10Bin(boolean KeepPreviuesValues) {
        for (int R = 0; R < 48; ++R) {
            this.Fuzzy10BinRules[R] = new FuzzyRules();
            this.Fuzzy10BinRules[R].Input1 = this.Fuzzy10BinRulesDefinition[R][0];
            this.Fuzzy10BinRules[R].Input2 = this.Fuzzy10BinRulesDefinition[R][1];
            this.Fuzzy10BinRules[R].Input3 = this.Fuzzy10BinRulesDefinition[R][2];
            this.Fuzzy10BinRules[R].Output = this.Fuzzy10BinRulesDefinition[R][3];
        }
        this.KeepPreviuesValues = KeepPreviuesValues;
    }

    private void FindMembershipValueForTriangles(double Input, double[] Triangles, double[] MembershipFunctionToSave) {
        int Temp = 0;
        for (int i = 0; i <= Triangles.length - 1; i += 4) {
            MembershipFunctionToSave[Temp] = 0.0;
            if (Input >= Triangles[i + 1] && Input <= Triangles[i + 2]) {
                MembershipFunctionToSave[Temp] = 1.0;
            }
            if (Input >= Triangles[i] && Input < Triangles[i + 1]) {
                MembershipFunctionToSave[Temp] = (Input - Triangles[i]) / (Triangles[i + 1] - Triangles[i]);
            }
            if (Input > Triangles[i + 2] && Input <= Triangles[i + 3]) {
                MembershipFunctionToSave[Temp] = (Input - Triangles[i + 2]) / (Triangles[i + 2] - Triangles[i + 3]) + 1.0;
            }
            ++Temp;
        }
    }

    private void LOM_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] Input3, double[] ResultTable) {
        int RuleActivation = -1;
        double LOM_MAXofMIN = 0.0;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0) || !(Input3[Rules[i].Input3] > 0.0)) continue;
            double Min = 0.0;
            Min = Math.min(Input1[Rules[i].Input1], Math.min(Input2[Rules[i].Input2], Input3[Rules[i].Input3]));
            if (!(Min > LOM_MAXofMIN)) continue;
            LOM_MAXofMIN = Min;
            RuleActivation = Rules[i].Output;
        }
        int n = RuleActivation;
        ResultTable[n] = ResultTable[n] + 1.0;
    }

    private void MultiParticipate_Equal_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] Input3, double[] ResultTable) {
        int RuleActivation = -1;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0) || !(Input3[Rules[i].Input3] > 0.0)) continue;
            int n = RuleActivation = Rules[i].Output;
            ResultTable[n] = ResultTable[n] + 1.0;
        }
    }

    private void MultiParticipate_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] Input3, double[] ResultTable) {
        int RuleActivation = -1;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0) || !(Input3[Rules[i].Input3] > 0.0)) continue;
            RuleActivation = Rules[i].Output;
            double Min = 0.0;
            Min = Math.min(Input1[Rules[i].Input1], Math.min(Input2[Rules[i].Input2], Input3[Rules[i].Input3]));
            int n = RuleActivation;
            ResultTable[n] = ResultTable[n] + Min;
        }
    }

    public double[] ApplyFilter(double Hue, double Saturation, double Value, int Method2) {
        if (!this.KeepPreviuesValues) {
            for (int i = 0; i < 10; ++i) {
                this.Fuzzy10BinHisto[i] = 0.0;
            }
        }
        this.FindMembershipValueForTriangles(Hue, this.HueMembershipValues, this.HueActivation);
        this.FindMembershipValueForTriangles(Saturation, this.SaturationMembershipValues, this.SaturationActivation);
        this.FindMembershipValueForTriangles(Value, this.ValueMembershipValues, this.ValueActivation);
        if (Method2 == 0) {
            this.LOM_Defazzificator(this.Fuzzy10BinRules, this.HueActivation, this.SaturationActivation, this.ValueActivation, this.Fuzzy10BinHisto);
        }
        if (Method2 == 1) {
            this.MultiParticipate_Equal_Defazzificator(this.Fuzzy10BinRules, this.HueActivation, this.SaturationActivation, this.ValueActivation, this.Fuzzy10BinHisto);
        }
        if (Method2 == 2) {
            this.MultiParticipate_Defazzificator(this.Fuzzy10BinRules, this.HueActivation, this.SaturationActivation, this.ValueActivation, this.Fuzzy10BinHisto);
        }
        return this.Fuzzy10BinHisto;
    }
}

