/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.fcth;

import net.semanticmetadata.lire.imageanalysis.fcth.FuzzyRules;

public class FuzzyFCTHpart {
    public double[] ResultsTable = new double[8];
    public double[] HorizontalMembershipValues = new double[]{0.0, 0.0, 20.0, 90.0, 20.0, 90.0, 255.0, 255.0};
    public double[] VerticalMembershipValues = new double[]{0.0, 0.0, 20.0, 90.0, 20.0, 90.0, 255.0, 255.0};
    public double[] EnergyMembershipValues = new double[]{0.0, 0.0, 20.0, 80.0, 20.0, 80.0, 255.0, 255.0};
    public FuzzyRules[] TextureRules = new FuzzyRules[8];
    public double[] FCTH = new double[192];
    public double[] HActivation = new double[2];
    public double[] VActivation = new double[2];
    public double[] EActivation = new double[2];
    public int[][] RulesDefinition = new int[][]{{0, 0, 0, 0}, {0, 0, 1, 1}, {0, 1, 0, 2}, {0, 1, 1, 3}, {1, 0, 0, 4}, {1, 0, 1, 5}, {1, 1, 0, 6}, {1, 1, 1, 7}};

    public FuzzyFCTHpart() {
        for (int R = 0; R < 8; ++R) {
            this.TextureRules[R] = new FuzzyRules();
            this.TextureRules[R].Input1 = this.RulesDefinition[R][0];
            this.TextureRules[R].Input2 = this.RulesDefinition[R][1];
            this.TextureRules[R].Input3 = this.RulesDefinition[R][2];
            this.TextureRules[R].Output = this.RulesDefinition[R][3];
        }
    }

    private void FindMembershipValueForTriangles(double Input, double[] Triangles, double[] MembershipFunctionToSave) {
        int Temp = 0;
        for (int i = 0; i <= Triangles.length - 1; i += 4) {
            MembershipFunctionToSave[Temp] = 0.0;
            if (Input >= Triangles[i + 1] && Input <= Triangles[i + 2]) {
                MembershipFunctionToSave[Temp] = 1.0;
            }
            if (Input >= Triangles[i] && Input < Triangles[i + 1]) {
                MembershipFunctionToSave[Temp] = (Input - Triangles[i]) / (Triangles[i + 1] - Triangles[i]);
            }
            if (Input > Triangles[i + 2] && Input <= Triangles[i + 3]) {
                MembershipFunctionToSave[Temp] = (Input - Triangles[i + 2]) / (Triangles[i + 2] - Triangles[i + 3]) + 1.0;
            }
            ++Temp;
        }
    }

    private void LOM_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] Input3, double[] ResultTable) {
        int RuleActivation = -1;
        double LOM_MAXofMIN = 0.0;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0) || !(Input3[Rules[i].Input3] > 0.0)) continue;
            double Min = 0.0;
            Min = Math.min(Input1[Rules[i].Input1], Math.min(Input2[Rules[i].Input2], Input3[Rules[i].Input3]));
            if (!(Min > LOM_MAXofMIN)) continue;
            LOM_MAXofMIN = Min;
            RuleActivation = Rules[i].Output;
        }
        int n = RuleActivation;
        ResultTable[n] = ResultTable[n] + 1.0;
    }

    private void MultiParticipate_Equal_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] Input3, double[] ResultTable) {
        int RuleActivation = -1;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0) || !(Input3[Rules[i].Input3] > 0.0)) continue;
            int n = RuleActivation = Rules[i].Output;
            ResultTable[n] = ResultTable[n] + 1.0;
        }
    }

    private void MultiParticipate_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] Input3, double[] ResultTable) {
        int RuleActivation = -1;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0) || !(Input3[Rules[i].Input3] > 0.0)) continue;
            RuleActivation = Rules[i].Output;
            double Min = 0.0;
            Min = Math.min(Input1[Rules[i].Input1], Math.min(Input2[Rules[i].Input2], Input3[Rules[i].Input3]));
            int n = RuleActivation;
            ResultTable[n] = ResultTable[n] + Min;
        }
    }

    public double[] ApplyFilter(double F1, double F2, double F3, double[] ColorValues, int Method2, int NumberOfColors) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.ResultsTable[i] = 0.0;
        }
        this.FindMembershipValueForTriangles(F1, this.HorizontalMembershipValues, this.HActivation);
        this.FindMembershipValueForTriangles(F2, this.VerticalMembershipValues, this.VActivation);
        this.FindMembershipValueForTriangles(F3, this.EnergyMembershipValues, this.EActivation);
        if (Method2 == 0) {
            this.LOM_Defazzificator(this.TextureRules, this.HActivation, this.VActivation, this.EActivation, this.ResultsTable);
        }
        if (Method2 == 1) {
            this.MultiParticipate_Equal_Defazzificator(this.TextureRules, this.HActivation, this.VActivation, this.EActivation, this.ResultsTable);
        }
        if (Method2 == 2) {
            this.MultiParticipate_Defazzificator(this.TextureRules, this.HActivation, this.VActivation, this.EActivation, this.ResultsTable);
        }
        for (i = 0; i < 8; ++i) {
            if (!(this.ResultsTable[i] > 0.0)) continue;
            for (int j = 0; j < NumberOfColors; ++j) {
                if (!(ColorValues[j] > 0.0)) continue;
                int n = NumberOfColors * i + j;
                this.FCTH[n] = this.FCTH[n] + this.ResultsTable[i] * ColorValues[j];
            }
        }
        return this.FCTH;
    }
}

