/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.joint;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class RankAndOpponent
extends Histogram
implements LireFeature {
    private int[] tmpIntensity = new int[1];
    final double sq2 = Math.sqrt(2.0);
    final double sq6 = Math.sqrt(3.0);
    final double sq3 = Math.sqrt(6.0);
    double o1;
    double o2;
    double o3;
    int tmp;

    public RankAndOpponent() {
        this.descriptor = new double[576];
    }

    @Override
    public void extract(BufferedImage bimg) {
        int j;
        int i;
        int[][] histogram = new int[64][9];
        for (int i2 = 0; i2 < histogram.length; ++i2) {
            for (int j2 = 0; j2 < histogram[i2].length; ++j2) {
                histogram[i2][j2] = 0;
            }
        }
        WritableRaster grey = ImageUtils.getGrayscaleImage(bimg).getRaster();
        WritableRaster raster = bimg.getRaster();
        int[] px = new int[3];
        int[] intens = new int[1];
        for (int x = 1; x < raster.getWidth() - 1; ++x) {
            for (int y = 1; y < raster.getHeight() - 1; ++y) {
                raster.getPixel(x, y, px);
                this.o1 = (double)(px[0] - px[1]) / this.sq2;
                this.o2 = (double)(px[0] + px[1] - 2 * px[2]) / this.sq6;
                this.o3 = (double)(px[0] + px[1] + px[2]) / this.sq3;
                this.o1 = (this.o1 + 255.0 / this.sq2) / (510.0 / this.sq2);
                this.o2 = (this.o2 + 510.0 / this.sq6) / (1020.0 / this.sq6);
                this.o3 /= 765.0 / this.sq3;
                int colorPos = (int)Math.min(Math.floor(this.o1 * 4.0), 3.0) + (int)Math.min(Math.floor(this.o2 * 4.0), 3.0) * 4 + (int)Math.min(3.0, Math.floor(this.o3 * 4.0)) * 4 * 4;
                int rank = 0;
                grey.getPixel(x, y, intens);
                if (this.getIntensity(x - 1, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x - 1, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x - 1, y, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y, grey) > intens[0]) {
                    // empty if block
                }
                int[] nArray = histogram[colorPos];
                int n = ++rank;
                nArray[n] = nArray[n] + 1;
            }
        }
        this.descriptor = new double[576];
        double max = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            for (j = 0; j < histogram[i].length; ++j) {
                max = Math.max((double)histogram[i][j], max);
            }
        }
        for (i = 0; i < histogram.length; ++i) {
            for (j = 0; j < histogram[i].length; ++j) {
                this.descriptor[i + 64 * j] = Math.floor(7.0 * ((double)histogram[i][j] / max));
            }
        }
    }

    private int getIntensity(int x, int y, WritableRaster grey) {
        grey.getPixel(x, y, this.tmpIntensity);
        return this.tmpIntensity[0];
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(this.descriptor.length * 2 + 25);
        sb.append("jophist");
        sb.append(' ');
        sb.append(this.descriptor.length);
        sb.append(' ');
        for (double aData : this.descriptor) {
            sb.append((int)aData);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (!st.nextToken().equals("jophist")) {
            throw new UnsupportedOperationException("This is not a RankAndOpponent descriptor.");
        }
        this.descriptor = new double[Integer.parseInt(st.nextToken())];
        for (int i = 0; i < this.descriptor.length; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IndexOutOfBoundsException("Too few numbers in string representation.");
            }
            this.descriptor[i] = Integer.parseInt(st.nextToken());
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.descriptor.length / 2];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = (int)(this.descriptor[i << 1] * 2.0) << 4;
            this.tmp |= (int)(this.descriptor[(i << 1) + 1] * 2.0);
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        for (int i = 0; i < in.length; ++i) {
            this.tmp = in[i] + 128;
            this.descriptor[(i << 1) + 1] = (double)(this.tmp & 0xF) / 2.0;
            this.descriptor[i << 1] = (double)(this.tmp >> 4) / 2.0;
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            this.tmp = in[i] + 128;
            this.descriptor[(i << 1) + 1] = (double)(this.tmp & 0xF) / 2.0;
            this.descriptor[i << 1] = (double)(this.tmp >> 4) / 2.0;
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        double[] result = new double[this.descriptor.length];
        for (int i = 0; i < this.descriptor.length; ++i) {
            result[i] = this.descriptor[i];
        }
        return result;
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof RankAndOpponent)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        return MetricsUtils.jsd(((RankAndOpponent)feature).descriptor, this.descriptor);
    }

    @Override
    public String getFeatureName() {
        return "Rank Opponent Joint Histogram";
    }

    @Override
    public String getFieldName() {
        return "f_jhropp";
    }
}

