/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mpeg7;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.semanticmetadata.lire.utils.ImageUtils;

public class ColorLayoutImpl {
    protected int[][] shape;
    protected int imgYSize;
    protected int imgXSize;
    protected BufferedImage img;
    protected static int[] availableCoeffNumbers = new int[]{1, 3, 6, 10, 15, 21, 28, 64};
    protected int numCCoeff = 6;
    protected int numYCoeff = 21;
    public int[] YCoeff = new int[this.numYCoeff];
    public int[] CbCoeff = new int[this.numCCoeff];
    public int[] CrCoeff = new int[this.numCCoeff];
    protected static int[] arrayZigZag = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    protected static double[][] arrayCosin = new double[][]{{0.3535534, 0.3535534, 0.3535534, 0.3535534, 0.3535534, 0.3535534, 0.3535534, 0.3535534}, {0.4903926, 0.4157348, 0.2777851, 0.09754516, -0.09754516, -0.2777851, -0.4157348, -0.4903926}, {0.4619398, 0.1913417, -0.1913417, -0.4619398, -0.4619398, -0.1913417, 0.1913417, 0.4619398}, {0.4157348, -0.09754516, -0.4903926, -0.2777851, 0.2777851, 0.4903926, 0.09754516, -0.4157348}, {0.3535534, -0.3535534, -0.3535534, 0.3535534, 0.3535534, -0.3535534, -0.3535534, 0.3535534}, {0.2777851, -0.4903926, 0.09754516, 0.4157348, -0.4157348, -0.09754516, 0.4903926, -0.2777851}, {0.1913417, -0.4619398, 0.4619398, -0.1913417, -0.1913417, 0.4619398, -0.4619398, 0.1913417}, {0.09754516, -0.2777851, 0.4157348, -0.4903926, 0.4903926, -0.4157348, 0.2777851, -0.09754516}};
    protected static int[][] weightMatrix = new int[3][64];
    protected BufferedImage colorLayoutImage;

    public ColorLayoutImpl() {
    }

    public ColorLayoutImpl(BufferedImage image) {
        this.img = image;
        this.imgYSize = image.getHeight();
        this.imgXSize = image.getWidth();
        this.init();
    }

    public ColorLayoutImpl(String descriptorValues) {
        this.setStringRepresentation(descriptorValues);
    }

    public ColorLayoutImpl(int numberOfYCoeff, int numberOfCCoeff, BufferedImage image) {
        this.numCCoeff = ColorLayoutImpl.getRightCoeffNumber(numberOfCCoeff);
        this.numYCoeff = ColorLayoutImpl.getRightCoeffNumber(numberOfYCoeff);
        this.img = image;
        this.imgYSize = image.getHeight();
        this.imgXSize = image.getWidth();
        this.init();
    }

    private void init() {
        this.shape = new int[3][64];
        this.YCoeff = new int[64];
        this.CbCoeff = new int[64];
        this.CrCoeff = new int[64];
        this.colorLayoutImage = null;
        this.extract();
    }

    public void extract(BufferedImage bimg) {
        this.img = ImageUtils.get8BitRGBImage(bimg);
        this.imgYSize = this.img.getHeight();
        this.imgXSize = this.img.getWidth();
        this.init();
    }

    private void createShape() {
        int k;
        int i;
        long[][] sum = new long[3][64];
        int[] cnt = new int[64];
        double yy = 0.0;
        for (i = 0; i < 64; ++i) {
            cnt[i] = 0;
            sum[0][i] = 0L;
            sum[1][i] = 0L;
            sum[2][i] = 0L;
            this.shape[0][i] = 0;
            this.shape[1][i] = 0;
            this.shape[2][i] = 0;
        }
        WritableRaster raster = this.img.getRaster();
        int[] pixel = new int[]{0, 0, 0};
        for (int y = 0; y < this.imgYSize; ++y) {
            for (int x = 0; x < this.imgXSize; ++x) {
                raster.getPixel(x, y, pixel);
                int R = pixel[0];
                int G = pixel[1];
                int B = pixel[2];
                int y_axis = (int)((double)y / ((double)this.imgYSize / 8.0));
                int x_axis = (int)((double)x / ((double)this.imgXSize / 8.0));
                k = (y_axis << 3) + x_axis;
                yy = (0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B) / 256.0;
                long[] lArray = sum[0];
                int n = k;
                lArray[n] = lArray[n] + (long)((int)(219.0 * yy + 16.5));
                long[] lArray2 = sum[1];
                int n2 = k;
                lArray2[n2] = lArray2[n2] + (long)((int)(126.33599999999998 * ((double)B / 256.0 * 1.0 - yy) + 128.5));
                long[] lArray3 = sum[2];
                int n3 = k;
                lArray3[n3] = lArray3[n3] + (long)((int)(159.712 * ((double)R / 256.0 * 1.0 - yy) + 128.5));
                int n4 = k;
                cnt[n4] = cnt[n4] + 1;
            }
        }
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (k = 0; k < 3; ++k) {
                    this.shape[k][(i << 3) + j] = cnt[(i << 3) + j] != 0 ? (int)(sum[k][(i << 3) + j] / (long)cnt[(i << 3) + j]) : 0;
                }
            }
        }
    }

    private static void Fdct(int[] shapes) {
        int k;
        double s;
        int j;
        int i;
        double[] dct = new double[64];
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                s = 0.0;
                for (k = 0; k < 8; ++k) {
                    s += arrayCosin[j][k] * (double)shapes[8 * i + k];
                }
                dct[8 * i + j] = s;
            }
        }
        for (j = 0; j < 8; ++j) {
            for (i = 0; i < 8; ++i) {
                s = 0.0;
                for (k = 0; k < 8; ++k) {
                    s += arrayCosin[i][k] * dct[8 * k + j];
                }
                shapes[8 * i + j] = (int)Math.floor(s + 0.499999);
            }
        }
    }

    private static int quant_ydc(int i) {
        int j = i > 192 ? 112 + (i - 192 >> 2) : (i > 160 ? 96 + (i - 160 >> 1) : (i > 96 ? 32 + (i - 96) : (i > 64 ? 16 + (i - 64 >> 1) : i >> 2)));
        return j;
    }

    private static int quant_cdc(int i) {
        int j = i > 191 ? 63 : (i > 160 ? 56 + (i - 160 >> 2) : (i > 144 ? 48 + (i - 144 >> 1) : (i > 112 ? 16 + (i - 112) : (i > 96 ? 8 + (i - 96 >> 1) : (i > 64 ? i - 64 >> 2 : 0)))));
        return j;
    }

    private static int quant_ac(int i) {
        if (i > 255) {
            i = 255;
        }
        if (i < -256) {
            i = -256;
        }
        int j = Math.abs(i) > 127 ? 64 + (Math.abs(i) >> 2) : (Math.abs(i) > 63 ? 32 + (Math.abs(i) >> 1) : Math.abs(i));
        j = i < 0 ? -j : j;
        return j += 128;
    }

    private int extract() {
        this.createShape();
        ColorLayoutImpl.Fdct(this.shape[0]);
        ColorLayoutImpl.Fdct(this.shape[1]);
        ColorLayoutImpl.Fdct(this.shape[2]);
        this.YCoeff[0] = ColorLayoutImpl.quant_ydc(this.shape[0][0] >> 3) >> 1;
        this.CbCoeff[0] = ColorLayoutImpl.quant_cdc(this.shape[1][0] >> 3);
        this.CrCoeff[0] = ColorLayoutImpl.quant_cdc(this.shape[2][0] >> 3);
        for (int i = 1; i < 64; ++i) {
            this.YCoeff[i] = ColorLayoutImpl.quant_ac(this.shape[0][arrayZigZag[i]] >> 1) >> 3;
            this.CbCoeff[i] = ColorLayoutImpl.quant_ac(this.shape[1][arrayZigZag[i]]) >> 3;
            this.CrCoeff[i] = ColorLayoutImpl.quant_ac(this.shape[2][arrayZigZag[i]]) >> 3;
        }
        this.setYCoeff(this.YCoeff);
        this.setCbCoeff(this.CbCoeff);
        this.setCrCoeff(this.CrCoeff);
        return 0;
    }

    private void setYCoeff(int[] YCoeff) {
        StringBuilder b = new StringBuilder(256);
        for (int i = 0; i < this.numYCoeff; ++i) {
            b.append(YCoeff[i]).append(' ');
        }
    }

    private void setCbCoeff(int[] CbCoeff) {
        StringBuilder b = new StringBuilder(256);
        for (int i = 0; i < this.numCCoeff; ++i) {
            b.append(CbCoeff[i]).append(' ');
        }
    }

    private void setCrCoeff(int[] CrCoeff) {
        StringBuilder b = new StringBuilder(256);
        for (int i = 0; i < this.numCCoeff; ++i) {
            b.append(CrCoeff[i]).append(' ');
        }
    }

    private static int getRightCoeffNumber(int num) {
        int val = 0;
        if (num <= 1) {
            val = 1;
        } else if (num <= 3) {
            val = 3;
        } else if (num <= 6) {
            val = 6;
        } else if (num <= 10) {
            val = 10;
        } else if (num <= 15) {
            val = 15;
        } else if (num <= 21) {
            val = 21;
        } else if (num <= 28) {
            val = 28;
        } else if (num > 28) {
            val = 64;
        }
        return val;
    }

    public static double getSimilarity(int[] YCoeff1, int[] CbCoeff1, int[] CrCoeff1, int[] YCoeff2, int[] CbCoeff2, int[] CrCoeff2) {
        int diffCb;
        int j;
        int sumCb = 0;
        int sumCr = 0;
        int sumY = 0;
        for (j = 0; j < Math.min(YCoeff1.length, YCoeff2.length); ++j) {
            diffCb = YCoeff1[j] - YCoeff2[j];
            sumY += weightMatrix[0][j] * diffCb * diffCb;
        }
        for (j = 0; j < Math.min(CbCoeff1.length, CbCoeff2.length); ++j) {
            diffCb = CbCoeff1[j] - CbCoeff2[j];
            sumCb += weightMatrix[1][j] * diffCb * diffCb;
            int diffCr = CrCoeff1[j] - CrCoeff2[j];
            sumCr += weightMatrix[2][j] * diffCr * diffCr;
        }
        return Math.sqrt(sumY) + Math.sqrt(sumCb) + Math.sqrt(sumCr);
    }

    private static void setWeightingValues() {
        ColorLayoutImpl.weightMatrix[0][0] = 2;
        ColorLayoutImpl.weightMatrix[0][2] = 2;
        ColorLayoutImpl.weightMatrix[0][1] = 2;
        ColorLayoutImpl.weightMatrix[1][0] = 2;
        ColorLayoutImpl.weightMatrix[1][2] = 1;
        ColorLayoutImpl.weightMatrix[1][1] = 1;
        ColorLayoutImpl.weightMatrix[2][0] = 4;
        ColorLayoutImpl.weightMatrix[2][2] = 2;
        ColorLayoutImpl.weightMatrix[2][1] = 2;
        for (int i = 0; i < 3; ++i) {
            for (int j = 3; j < 64; ++j) {
                ColorLayoutImpl.weightMatrix[i][j] = 1;
            }
        }
    }

    private static BufferedImage YCrCb2RGB(int[][] rgbSmallImage) {
        BufferedImage br = new BufferedImage(8, 8, 1);
        WritableRaster r = br.getRaster();
        int[] pixel = new int[3];
        for (int i = 0; i < 64; ++i) {
            double rImage = ((double)rgbSmallImage[0][i] - 16.0) * 256.0 / 219.0;
            double gImage = ((double)rgbSmallImage[1][i] - 128.0) * 256.0 / 224.0;
            double bImage = ((double)rgbSmallImage[2][i] - 128.0) * 256.0 / 224.0;
            pixel[0] = Math.max(0, (int)(rImage + 1.402 * bImage + 0.5));
            pixel[1] = Math.max(0, (int)(rImage + -0.34413 * gImage + -0.71414 * bImage + 0.5));
            pixel[2] = Math.max(0, (int)(rImage + 1.772 * gImage + 0.5));
            r.setPixel(i % 8, i >> 3, pixel);
        }
        return br;
    }

    public BufferedImage getColorLayoutImage() {
        if (this.colorLayoutImage != null) {
            return this.colorLayoutImage;
        }
        int[][] smallReImage = new int[3][64];
        smallReImage[0][0] = ColorLayoutImpl.IquantYdc(this.YCoeff[0]);
        smallReImage[1][0] = ColorLayoutImpl.IquantCdc(this.CbCoeff[0]);
        smallReImage[2][0] = ColorLayoutImpl.IquantCdc(this.CrCoeff[0]);
        for (int i = 1; i < 64; ++i) {
            smallReImage[0][ColorLayoutImpl.arrayZigZag[i]] = ColorLayoutImpl.IquantYac(this.YCoeff[i]);
            smallReImage[1][ColorLayoutImpl.arrayZigZag[i]] = ColorLayoutImpl.IquantCac(this.CbCoeff[i]);
            smallReImage[2][ColorLayoutImpl.arrayZigZag[i]] = ColorLayoutImpl.IquantCac(this.CrCoeff[i]);
        }
        ColorLayoutImpl.Idct(smallReImage[0]);
        ColorLayoutImpl.Idct(smallReImage[1]);
        ColorLayoutImpl.Idct(smallReImage[2]);
        this.colorLayoutImage = ColorLayoutImpl.YCrCb2RGB(smallReImage);
        return this.colorLayoutImage;
    }

    private static void Idct(int[] iShapes) {
        int k;
        double s;
        int v;
        int u;
        double[] dct = new double[64];
        for (u = 0; u < 8; ++u) {
            for (v = 0; v < 8; ++v) {
                s = 0.0;
                for (k = 0; k < 8; ++k) {
                    s += arrayCosin[k][v] * (double)iShapes[8 * u + k];
                }
                dct[8 * u + v] = s;
            }
        }
        for (v = 0; v < 8; ++v) {
            for (u = 0; u < 8; ++u) {
                s = 0.0;
                for (k = 0; k < 8; ++k) {
                    s += arrayCosin[k][u] * dct[8 * k + v];
                }
                iShapes[8 * u + v] = (int)Math.floor(s + 0.499999);
            }
        }
    }

    private static int IquantYdc(int i) {
        int j = (i <<= 1) > 112 ? 194 + (i - 112 << 2) : (i > 96 ? 162 + (i - 96 << 1) : (i > 32 ? 96 + (i - 32) : (i > 16 ? 66 + (i - 16 << 1) : i << 2)));
        return j << 3;
    }

    private static int IquantCdc(int i) {
        int j = i > 63 ? 192 : (i > 56 ? 162 + (i - 56 << 2) : (i > 48 ? 145 + (i - 48 << 1) : (i > 16 ? 112 + (i - 16) : (i > 8 ? 97 + (i - 8 << 1) : (i > 0 ? 66 + (i << 2) : 64)))));
        return j << 3;
    }

    private static int IquantYac(int i) {
        i <<= 3;
        if ((i -= 128) > 128) {
            i = 128;
        }
        if (i < -128) {
            i = -128;
        }
        int j = Math.abs(i) > 96 ? (Math.abs(i) << 2) - 256 : (Math.abs(i) > 64 ? (Math.abs(i) << 1) - 64 : Math.abs(i));
        j = i < 0 ? -j : j;
        return j << 1;
    }

    private static int IquantCac(int i) {
        i <<= 3;
        if ((i -= 128) > 128) {
            i = 128;
        }
        if (i < -128) {
            i = -128;
        }
        int j = Math.abs(i) > 96 ? (Math.abs(i) << 2) - 256 : (Math.abs(i) > 64 ? (Math.abs(i) << 1) - 64 : Math.abs(i));
        j = i < 0 ? -j : j;
        return j;
    }

    public int getNumberOfCCoeff() {
        return this.numCCoeff;
    }

    public void setNumberOfCCoeff(int numberOfCCoeff) {
        this.numCCoeff = numberOfCCoeff;
    }

    public int getNumberOfYCoeff() {
        return this.numYCoeff;
    }

    public void setNumberOfYCoeff(int numberOfYCoeff) {
        this.numYCoeff = numberOfYCoeff;
    }

    public String getStringRepresentation() {
        int i;
        StringBuilder sb = new StringBuilder(256);
        StringBuilder sbtmp = new StringBuilder(256);
        for (i = 0; i < this.numYCoeff; ++i) {
            sb.append(this.YCoeff[i]);
            if (i + 1 >= this.numYCoeff) continue;
            sb.append(' ');
        }
        sb.append("z");
        for (i = 0; i < this.numCCoeff; ++i) {
            sb.append(this.CbCoeff[i]);
            if (i + 1 < this.numCCoeff) {
                sb.append(' ');
            }
            sbtmp.append(this.CrCoeff[i]);
            if (i + 1 >= this.numCCoeff) continue;
            sbtmp.append(' ');
        }
        sb.append("z");
        sb.append((CharSequence)sbtmp);
        return sb.toString();
    }

    public void setStringRepresentation(String descriptor) {
        int i;
        String[] coeffs = descriptor.split("z");
        String[] y = coeffs[0].split(" ");
        String[] cb = coeffs[1].split(" ");
        String[] cr = coeffs[2].split(" ");
        this.numYCoeff = y.length;
        this.numCCoeff = Math.min(cb.length, cr.length);
        this.YCoeff = new int[this.numYCoeff];
        this.CbCoeff = new int[this.numCCoeff];
        this.CrCoeff = new int[this.numCCoeff];
        for (i = 0; i < this.numYCoeff; ++i) {
            this.YCoeff[i] = Integer.parseInt(y[i]);
        }
        for (i = 0; i < this.numCCoeff; ++i) {
            this.CbCoeff[i] = Integer.parseInt(cb[i]);
            this.CrCoeff[i] = Integer.parseInt(cr[i]);
        }
    }

    public int[] getYCoeff() {
        return this.YCoeff;
    }

    public int[] getCbCoeff() {
        return this.CbCoeff;
    }

    public int[] getCrCoeff() {
        return this.CrCoeff;
    }

    static {
        ColorLayoutImpl.weightMatrix[0][0] = 2;
        ColorLayoutImpl.weightMatrix[0][2] = 2;
        ColorLayoutImpl.weightMatrix[0][1] = 2;
        ColorLayoutImpl.weightMatrix[1][0] = 2;
        ColorLayoutImpl.weightMatrix[1][2] = 1;
        ColorLayoutImpl.weightMatrix[1][1] = 1;
        ColorLayoutImpl.weightMatrix[2][0] = 4;
        ColorLayoutImpl.weightMatrix[2][2] = 2;
        ColorLayoutImpl.weightMatrix[2][1] = 2;
        for (int i = 0; i < 3; ++i) {
            for (int j = 3; j < 64; ++j) {
                ColorLayoutImpl.weightMatrix[i][j] = 1;
            }
        }
    }
}

