/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexing.tools;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.indexing.parallel.WorkItem;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class ParallelExtractor
implements Runnable {
    public static final String[] features = new String[]{"net.semanticmetadata.lire.imageanalysis.CEDD", "net.semanticmetadata.lire.imageanalysis.FCTH", "net.semanticmetadata.lire.imageanalysis.OpponentHistogram", "net.semanticmetadata.lire.imageanalysis.joint.JointHistogram", "net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram", "net.semanticmetadata.lire.imageanalysis.ColorLayout", "net.semanticmetadata.lire.imageanalysis.EdgeHistogram", "net.semanticmetadata.lire.imageanalysis.Gabor", "net.semanticmetadata.lire.imageanalysis.JCD", "net.semanticmetadata.lire.imageanalysis.JpegCoefficientHistogram", "net.semanticmetadata.lire.imageanalysis.ScalableColor", "net.semanticmetadata.lire.imageanalysis.SimpleColorHistogram", "net.semanticmetadata.lire.imageanalysis.Tamura", "net.semanticmetadata.lire.imageanalysis.LuminanceLayout", "net.semanticmetadata.lire.imageanalysis.PHOG"};
    public static final String[] featureFieldNames = new String[]{"featureCEDD", "featureFCTH", "featOpHist", "featureJointHist", "featureAutoColorCorrelogram", "descriptorColorLayout", "descriptorEdgeHistogram", "featureGabor", "featureJCD", "featureJpegCoeffs", "descriptorScalableColor", "featureColorHistogram", "featureTAMURA", "featLumLay", "featPHOG"};
    static HashMap<String, Integer> feature2index = new HashMap(features.length);
    private static boolean force;
    private static int numberOfThreads;
    Stack<WorkItem> images = new Stack();
    boolean ended = false;
    int overallCount = 0;
    OutputStream dos = null;
    LinkedList<LireFeature> listOfFeatures = new LinkedList();
    File fileList = null;
    File outFile = null;
    private int monitoringInterval = 10;
    private int maxSideLength = -1;

    public static void setNumberOfThreads(int numberOfThreads) {
        ParallelExtractor.numberOfThreads = numberOfThreads;
    }

    public static void main(String[] args) throws IOException {
        ParallelExtractor e = new ParallelExtractor();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i")) {
                if (i + 1 < args.length) {
                    e.setFileList(new File(args[i + 1]));
                    continue;
                }
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-o")) {
                if (i + 1 < args.length) {
                    e.setOutFile(new File(args[i + 1]));
                    continue;
                }
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-m")) {
                if (i + 1 < args.length) {
                    try {
                        int s = Integer.parseInt(args[i + 1]);
                        if (s <= 10) continue;
                        e.setMaxSideLength(s);
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                        ParallelExtractor.printHelp();
                    }
                    continue;
                }
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-f")) {
                force = true;
                continue;
            }
            if (arg.startsWith("-h")) {
                ParallelExtractor.printHelp();
                continue;
            }
            if (arg.startsWith("-n")) {
                if (i + 1 < args.length) {
                    try {
                        numberOfThreads = Integer.parseInt(args[i + 1]);
                    }
                    catch (Exception e1) {
                        System.err.println("Could not set number of threads to \"" + args[i + 1] + "\".");
                        e1.printStackTrace();
                    }
                    continue;
                }
                ParallelExtractor.printHelp();
                continue;
            }
            if (!arg.startsWith("-c")) continue;
            Properties p = new Properties();
            p.load(new FileInputStream(new File(args[i + 1])));
            Enumeration<?> enumeration = p.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.toLowerCase().startsWith("feature.")) continue;
                try {
                    e.addFeature((LireFeature)Class.forName(p.getProperty(key)).newInstance());
                }
                catch (Exception e1) {
                    System.err.println("Could not add feature named " + p.getProperty(key));
                    e1.printStackTrace();
                }
            }
        }
        if (!e.isConfigured()) {
            ParallelExtractor.printHelp();
        } else {
            e.run();
        }
    }

    private static void printHelp() {
        System.out.println("Help for the ParallelExtractor class.\n=============================\nThis help text is shown if you start the ParallelExtractor with the '-h' option.\n\n1. Usage\n========\n$> ParallelExtractor -i <infile> [-o <outfile>] -c <configfile> [-n <threads>] [-m <max_side_length>]\n\nNote: if you don't specify an outfile just \".data\" is appended to the infile for output.\n\n2. Config File\n==============\nThe config file is a simple java Properties file. It basically gives the \nemployed features as a list of properties, just like:\n\nfeature.1=net.semanticmetadata.lire.imageanalysis.CEDD\nfeature.2=net.semanticmetadata.lire.imageanalysis.FCTH\n\n... and so on. ");
    }

    public void addFeature(LireFeature feature) {
        this.listOfFeatures.add(feature);
    }

    public void setFileList(File fileList) {
        this.fileList = fileList;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public int getMaxSideLength() {
        return this.maxSideLength;
    }

    public void setMaxSideLength(int maxSideLength) {
        this.maxSideLength = maxSideLength;
    }

    private boolean isConfigured() {
        boolean configured = true;
        if (this.fileList == null || !this.fileList.exists()) {
            configured = false;
        } else if (this.outFile == null) {
            try {
                this.outFile = new File(this.fileList.getCanonicalPath() + ".data");
                System.out.println("Setting out file to " + this.outFile.getCanonicalFile());
            }
            catch (IOException e) {
                configured = false;
            }
        } else if (this.outFile.exists() && !force) {
            System.err.println(this.outFile.getName() + " already exists. Please delete or choose another outfile.");
            configured = false;
        }
        if (this.listOfFeatures.size() < 1) {
            configured = false;
        }
        return configured;
    }

    @Override
    public void run() {
        if (this.fileList == null || !this.fileList.exists()) {
            System.err.println("No text file with a list of images given.");
            return;
        }
        if (this.listOfFeatures.size() == 0) {
            System.err.println("No features to extract given.");
            return;
        }
        try {
            this.dos = new BufferedOutputStream(new FileOutputStream(this.outFile));
            Thread p = new Thread(new Producer());
            p.start();
            LinkedList<Thread> threads = new LinkedList<Thread>();
            long l = System.currentTimeMillis();
            for (int i = 0; i < numberOfThreads; ++i) {
                Thread c = new Thread(new Consumer());
                c.start();
                threads.add(c);
            }
            Thread m = new Thread(new Monitoring());
            m.start();
            Iterator iterator = threads.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).join();
            }
            long l1 = System.currentTimeMillis() - l;
            System.out.println("Analyzed " + this.overallCount + " images in " + l1 / 1000L + " seconds, ~" + (this.overallCount > 0 ? Long.valueOf(l1 / (long)this.overallCount) : "inf.") + " ms each.");
            this.dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addFeatures(List features) {
        for (LireFeature next : this.listOfFeatures) {
            try {
                features.add(next.getClass().newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        for (int i = 0; i < features.length; ++i) {
            feature2index.put(features[i], i);
        }
        force = false;
        numberOfThreads = 4;
    }

    class Consumer
    implements Runnable {
        WorkItem tmp = null;
        LinkedList<LireFeature> features = new LinkedList();
        int count = 0;
        boolean locallyEnded = false;

        Consumer() {
            ParallelExtractor.this.addFeatures(this.features);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] myBuffer = new byte[0xA00000];
            int bufferCount = 0;
            while (!this.locallyEnded) {
                Stack<WorkItem> stack = ParallelExtractor.this.images;
                synchronized (stack) {
                    while (ParallelExtractor.this.images.empty() && !ParallelExtractor.this.ended) {
                        try {
                            ParallelExtractor.this.images.wait(200L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (ParallelExtractor.this.images.empty() && ParallelExtractor.this.ended) {
                        this.locallyEnded = true;
                    }
                    if (!ParallelExtractor.this.images.empty() && !this.locallyEnded) {
                        this.tmp = ParallelExtractor.this.images.pop();
                        ++this.count;
                        ++ParallelExtractor.this.overallCount;
                    }
                }
                try {
                    bufferCount = 0;
                    if (this.locallyEnded) continue;
                    ByteArrayInputStream b = new ByteArrayInputStream(this.tmp.getBuffer());
                    BufferedImage img = ImageIO.read(b);
                    if (ParallelExtractor.this.maxSideLength > 50) {
                        img = ImageUtils.scaleImage(img, ParallelExtractor.this.maxSideLength);
                    }
                    byte[] tmpBytes = this.tmp.getFileName().getBytes();
                    System.arraycopy(SerializationUtils.toBytes(tmpBytes.length), 0, myBuffer, 0, 4);
                    System.arraycopy(tmpBytes, 0, myBuffer, bufferCount += 4, tmpBytes.length);
                    bufferCount += tmpBytes.length;
                    for (LireFeature feature : this.features) {
                        feature.extract(img);
                        myBuffer[bufferCount] = (byte)feature2index.get(feature.getClass().getName()).intValue();
                        tmpBytes = feature.getByteArrayRepresentation();
                        System.arraycopy(SerializationUtils.toBytes(tmpBytes.length), 0, myBuffer, ++bufferCount, 4);
                        System.arraycopy(tmpBytes, 0, myBuffer, bufferCount += 4, tmpBytes.length);
                        bufferCount += tmpBytes.length;
                    }
                    OutputStream outputStream = ParallelExtractor.this.dos;
                    synchronized (outputStream) {
                        ParallelExtractor.this.dos.write(myBuffer, 0, bufferCount);
                        ParallelExtractor.this.dos.write(-1);
                        ParallelExtractor.this.dos.flush();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error processing file " + this.tmp.getFileName());
                    e.printStackTrace();
                }
            }
        }
    }

    class Producer
    implements Runnable {
        Producer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int tmpSize = 0;
            try {
                BufferedReader br = new BufferedReader(new FileReader(ParallelExtractor.this.fileList));
                String file = null;
                File next = null;
                while ((file = br.readLine()) != null) {
                    next = new File(file);
                    Object img = null;
                    try {
                        int fileSize = (int)next.length();
                        byte[] buffer = new byte[fileSize];
                        FileInputStream fis = new FileInputStream(next);
                        fis.read(buffer);
                        String path = next.getCanonicalPath();
                        Stack<WorkItem> stack = ParallelExtractor.this.images;
                        synchronized (stack) {
                            ParallelExtractor.this.images.add(new WorkItem(path, buffer));
                            tmpSize = ParallelExtractor.this.images.size();
                            if (tmpSize > 500) {
                                ParallelExtractor.this.images.wait(500L);
                            }
                            ParallelExtractor.this.images.notify();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Could not read image " + file + ": " + e.getMessage());
                    }
                    try {
                        if (tmpSize <= 500) continue;
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Stack<WorkItem> stack = ParallelExtractor.this.images;
            synchronized (stack) {
                ParallelExtractor.this.ended = true;
                ParallelExtractor.this.images.notifyAll();
            }
        }
    }

    class Monitoring
    implements Runnable {
        Monitoring() {
        }

        @Override
        public void run() {
            long ms = System.currentTimeMillis();
            try {
                Thread.sleep(1000 * ParallelExtractor.this.monitoringInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (!ParallelExtractor.this.ended) {
                try {
                    long time = System.currentTimeMillis() - ms;
                    System.out.println("Analyzed " + ParallelExtractor.this.overallCount + " images in " + time / 1000L + " seconds, " + (ParallelExtractor.this.overallCount > 0 ? Long.valueOf(time / (long)ParallelExtractor.this.overallCount) : "n.a.") + " ms each (" + ParallelExtractor.this.images.size() + " images currently in queue).");
                    Thread.sleep(1000 * ParallelExtractor.this.monitoringInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

