/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.distort.AddRadialPtoP_F32;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.distort.RemoveRadialPtoP_F64;
import boofcv.alg.feature.shapes.SplitMergeLineFitLoop;
import boofcv.alg.fiducial.FitQuadrilaterialEM;
import boofcv.alg.fiducial.FoundFiducial;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.calibration.Zhang99DecomposeHomography;
import boofcv.alg.geo.h.HomographyLinear4;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.ConnectRule;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.distort.SequencePointTransform_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.homography.UtilHomography;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;

public abstract class BaseDetectFiducialSquare<T extends ImageSingleBand> {
    private FastQueue<FoundFiducial> found = new FastQueue(FoundFiducial.class, true);
    private InputToBinary<T> thresholder;
    private double minContourFraction;
    private int minimumContour;
    private double minimumArea;
    private ImageUInt8 binary = new ImageUInt8(1, 1);
    private Point2D_I32[] tableDistPixel;
    private FastQueue<Point2D_I32> contourUndist = new FastQueue(Point2D_I32.class, false);
    private LinearContourLabelChang2004 contourFinder = new LinearContourLabelChang2004(ConnectRule.FOUR);
    private ImageSInt32 labeled = new ImageSInt32(1, 1);
    private SplitMergeLineFitLoop fitPolygon;
    private FastQueue<Quadrilateral_F64> candidates = new FastQueue(Quadrilateral_F64.class, true);
    private ImageFloat32 square;
    private HomographyLinear4 computeHomography = new HomographyLinear4(true);
    private DenseMatrix64F H = new DenseMatrix64F(3, 3);
    private List<AssociatedPair> pairsRemovePerspective = new ArrayList<AssociatedPair>();
    private ImageDistort<T, ImageFloat32> removePerspective;
    private PointTransformHomography_F32 transformHomography = new PointTransformHomography_F32();
    private AddRadialPtoP_F32 addRadialDistortion = new AddRadialPtoP_F32();
    private FitQuadrilaterialEM fitQuad = new FitQuadrilaterialEM();
    private Result result = new Result();
    private Class<T> inputType;
    List<AssociatedPair> pairsPose = new ArrayList<AssociatedPair>();
    Zhang99DecomposeHomography homographyToPose = new Zhang99DecomposeHomography();

    protected BaseDetectFiducialSquare(InputToBinary<T> thresholder, SplitMergeLineFitLoop fitPolygon, int squarePixels, double minContourFraction, Class<T> inputType) {
        this.thresholder = thresholder;
        this.inputType = inputType;
        this.minContourFraction = minContourFraction;
        this.fitPolygon = fitPolygon;
        this.square = new ImageFloat32(squarePixels, squarePixels);
        for (int i = 0; i < 4; ++i) {
            this.pairsRemovePerspective.add(new AssociatedPair());
            this.pairsPose.add(new AssociatedPair());
        }
        this.removePerspective = FactoryDistort.distort((boolean)false, (InterpolatePixelS)FactoryInterpolation.bilinearPixelS(inputType), (ImageBorder)FactoryImageBorder.general(inputType, (BorderType)BorderType.EXTENDED), ImageFloat32.class);
        SequencePointTransform_F32 sequence = new SequencePointTransform_F32(new PointTransform_F32[]{this.transformHomography, this.addRadialDistortion});
        PointToPixelTransform_F32 squareToInput = new PointToPixelTransform_F32((PointTransform_F32)sequence);
        this.removePerspective.setModel((PixelTransform_F32)squareToInput);
        this.tableDistPixel = new Point2D_I32[0];
    }

    public void configure(double squareWidth, IntrinsicParameters intrinsic) {
        this.binary.reshape(intrinsic.width, intrinsic.height);
        this.labeled.reshape(intrinsic.width, intrinsic.height);
        this.minimumContour = (int)((double)intrinsic.width * this.minContourFraction);
        this.minimumArea = Math.pow((double)this.minimumContour / 4.0, 2.0);
        this.pairsPose.get((int)0).p1.set(squareWidth / 2.0, squareWidth / 2.0);
        this.pairsPose.get((int)1).p1.set(squareWidth / 2.0, -squareWidth / 2.0);
        this.pairsPose.get((int)2).p1.set(-squareWidth / 2.0, -squareWidth / 2.0);
        this.pairsPose.get((int)3).p1.set(-squareWidth / 2.0, squareWidth / 2.0);
        DenseMatrix64F K = new DenseMatrix64F(3, 3);
        PerspectiveOps.calibrationMatrix((IntrinsicParameters)intrinsic, (DenseMatrix64F)K);
        this.homographyToPose.setCalibrationMatrix(K);
        this.addRadialDistortion.set(intrinsic.fx, intrinsic.fy, intrinsic.skew, intrinsic.cx, intrinsic.cy, intrinsic.radial);
        RemoveRadialPtoP_F64 removeLensDistort = new RemoveRadialPtoP_F64();
        removeLensDistort.set(intrinsic.fx, intrinsic.fy, intrinsic.skew, intrinsic.cx, intrinsic.cy, intrinsic.radial);
        int N = intrinsic.width * intrinsic.height;
        Point2D_F64 p = new Point2D_F64();
        if (this.tableDistPixel.length < N) {
            this.tableDistPixel = new Point2D_I32[N];
            for (int i = 0; i < N; ++i) {
                removeLensDistort.compute((double)(i % intrinsic.width), (double)(i / intrinsic.width), p);
                this.tableDistPixel[i] = new Point2D_I32((int)Math.round(p.x), (int)Math.round(p.y));
            }
        }
    }

    public void process(T gray) {
        this.found.reset();
        this.candidates.reset();
        this.thresholder.process(gray, (ImageBase)this.binary);
        this.findCandidateShapes();
        for (int i = 0; i < this.candidates.size; ++i) {
            Quadrilateral_F64 q = (Quadrilateral_F64)this.candidates.get(i);
            this.pairsRemovePerspective.get(0).set(0.0, 0.0, q.a.x, q.a.y);
            this.pairsRemovePerspective.get(1).set((double)(this.square.width - 1), 0.0, q.b.x, q.b.y);
            this.pairsRemovePerspective.get(2).set((double)(this.square.width - 1), (double)(this.square.height - 1), q.c.x, q.c.y);
            this.pairsRemovePerspective.get(3).set(0.0, (double)(this.square.height - 1), q.d.x, q.d.y);
            this.computeHomography.process(this.pairsRemovePerspective, this.H);
            UtilHomography.convert((DenseMatrix64F)this.H, (Homography2D_F32)this.transformHomography.getModel());
            this.removePerspective.apply(gray, (ImageBase)this.square);
            if (!this.processSquare(this.square, this.result)) continue;
            FoundFiducial f = (FoundFiducial)this.found.grow();
            f.index = this.result.which;
            f.location.set(q);
            for (int j = 0; j < this.result.rotation; ++j) {
                this.rotateClockWise(q);
            }
            this.computeTargetToWorld(q, f.targetToSensor);
        }
    }

    private void rotateClockWise(Quadrilateral_F64 quad) {
        Point2D_F64 d;
        Point2D_F64 a = quad.a;
        Point2D_F64 b = quad.b;
        Point2D_F64 c = quad.c;
        quad.a = d = quad.d;
        quad.b = a;
        quad.c = b;
        quad.d = c;
    }

    private void findCandidateShapes() {
        this.contourFinder.process(this.binary, this.labeled);
        int endX = this.binary.width - 1;
        int endY = this.binary.height - 1;
        FastQueue blobs = this.contourFinder.getContours();
        for (int i = 0; i < blobs.size; ++i) {
            Contour c = (Contour)blobs.get(i);
            if (c.internal.isEmpty() || c.external.size() < this.minimumContour) continue;
            boolean skip = false;
            this.contourUndist.reset();
            for (int j = 0; j < c.external.size(); ++j) {
                Point2D_I32 p = (Point2D_I32)c.external.get(j);
                if (p.x == 0 || p.y == 0 || p.x == endX || p.y == endY) {
                    skip = true;
                    break;
                }
                this.contourUndist.add((Object)this.tableDistPixel[p.y * this.binary.width + p.x]);
            }
            if (skip) continue;
            this.fitPolygon.process(this.contourUndist.toList());
            GrowQueue_I32 splits = this.fitPolygon.getSplits();
            if (splits.size > 8 || splits.size < 4) continue;
            Quadrilateral_F64 q = (Quadrilateral_F64)this.candidates.grow();
            if (!this.fitQuad.fit(this.contourUndist.toList(), splits, q)) {
                this.candidates.removeTail();
                continue;
            }
            double area = q.area();
            if (!UtilEjml.isUncountable((double)area) && !(area < this.minimumArea)) continue;
            this.candidates.removeTail();
        }
    }

    public void computeTargetToWorld(Quadrilateral_F64 quad, Se3_F64 targetToWorld) {
        this.pairsPose.get((int)0).p2.set(quad.a);
        this.pairsPose.get((int)1).p2.set(quad.b);
        this.pairsPose.get((int)2).p2.set(quad.c);
        this.pairsPose.get((int)3).p2.set(quad.d);
        if (!this.computeHomography.process(this.pairsPose, this.H)) {
            throw new RuntimeException("Compute homography failed!");
        }
        targetToWorld.set(this.homographyToPose.decompose(this.H));
    }

    public FastQueue<FoundFiducial> getFound() {
        return this.found;
    }

    public ImageUInt8 getBinary() {
        return this.binary;
    }

    protected abstract boolean processSquare(ImageFloat32 var1, Result var2);

    public Class<T> getInputType() {
        return this.inputType;
    }

    public static class Result {
        int which;
        int rotation;
    }
}

