/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.List;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class ExhaustiveNeighbor {
    int N;
    List<double[]> points;
    double bestDistance;
    GrowQueue_F64 distances = new GrowQueue_F64();
    GrowQueue_I32 indexes = new GrowQueue_I32();
    GrowQueue_I32 indexesSort = new GrowQueue_I32();

    public ExhaustiveNeighbor(int n) {
        this.N = n;
    }

    public ExhaustiveNeighbor() {
    }

    public void setN(int n) {
        this.N = n;
    }

    public void setPoints(List<double[]> points) {
        this.points = points;
    }

    public int findClosest(double[] p, double maxDistance) {
        int best = -1;
        this.bestDistance = maxDistance;
        for (int i = 0; i < this.points.size(); ++i) {
            double[] c = this.points.get(i);
            double distanceC = 0.0;
            for (int j = 0; j < this.N; ++j) {
                double d = p[j] - c[j];
                distanceC += d * d;
            }
            if (!(distanceC <= this.bestDistance)) continue;
            this.bestDistance = distanceC;
            best = i;
        }
        return best;
    }

    public void findClosestN(double[] p, double maxDistance, int numNeighbors, GrowQueue_I32 outputIndex, GrowQueue_F64 outputDistance) {
        int i;
        this.distances.reset();
        this.indexes.reset();
        for (i = 0; i < this.points.size(); ++i) {
            double[] c = this.points.get(i);
            double distanceC = 0.0;
            for (int j = 0; j < this.N; ++j) {
                double d = p[j] - c[j];
                distanceC += d * d;
            }
            if (!(distanceC <= maxDistance)) continue;
            this.distances.add(distanceC);
            this.indexes.add(i);
        }
        if ((numNeighbors = Math.min(this.distances.size, numNeighbors)) == 0) {
            return;
        }
        this.indexesSort.resize(this.distances.size);
        QuickSelect.selectIndex(this.distances.data, numNeighbors - 1, this.distances.size, this.indexesSort.data);
        for (i = 0; i < numNeighbors; ++i) {
            int index = this.indexes.get(this.indexesSort.get(i));
            outputIndex.add(index);
            outputDistance.add(this.distances.get(this.indexesSort.get(i)));
        }
    }

    public double getBestDistance() {
        return this.bestDistance;
    }
}

