/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.struct.FastQueue;

public class KdTreeSearchNStandard
implements KdTreeSearchN {
    private KdTree tree;
    private double[] target;
    private double maxDistanceSq = Double.MAX_VALUE;
    private double mostDistantNeighborSq;
    private int mostDistantNeighborIndex;
    private int searchN;

    @Override
    public void setTree(KdTree tree) {
        this.tree = tree;
    }

    @Override
    public void setMaxDistance(double maxDistance) {
        this.maxDistanceSq = maxDistance;
    }

    @Override
    public void findNeighbor(double[] target, int searchN, FastQueue<KdTreeResult> results) {
        if (searchN <= 0) {
            throw new IllegalArgumentException("I'm sorry, but I refuse to search for less than or equal to 0 neighbors.");
        }
        if (this.tree.root == null) {
            return;
        }
        this.searchN = searchN;
        this.target = target;
        this.mostDistantNeighborSq = this.maxDistanceSq;
        this.stepClosest(this.tree.root, results);
    }

    private void stepClosest(KdTree.Node node, FastQueue<KdTreeResult> neighbors) {
        KdTree.Node further;
        KdTree.Node nearer;
        if (node == null) {
            return;
        }
        this.checkBestDistance(node, neighbors);
        if (node.isLeaf()) {
            return;
        }
        double splitValue = node.point[node.split];
        if (this.target[node.split] <= splitValue) {
            nearer = node.left;
            further = node.right;
        } else {
            nearer = node.right;
            further = node.left;
        }
        this.stepClosest(nearer, neighbors);
        double dx = splitValue - this.target[node.split];
        if (dx * dx <= this.mostDistantNeighborSq && (neighbors.size() < this.searchN || dx * dx < this.mostDistantNeighborSq)) {
            this.stepClosest(further, neighbors);
        }
    }

    private void checkBestDistance(KdTree.Node node, FastQueue<KdTreeResult> neighbors) {
        block3: {
            double distSq;
            block4: {
                distSq = KdTree.distanceSq(node, this.target, this.tree.N);
                if (!(distSq <= this.mostDistantNeighborSq)) break block3;
                if (neighbors.size() >= this.searchN) break block4;
                KdTreeResult r = neighbors.grow();
                r.distance = distSq;
                r.node = node;
                if (neighbors.size() != this.searchN) break block3;
                this.mostDistantNeighborSq = -1.0;
                for (int i = 0; i < this.searchN; ++i) {
                    r = neighbors.get(i);
                    if (!(r.distance > this.mostDistantNeighborSq)) continue;
                    this.mostDistantNeighborSq = r.distance;
                    this.mostDistantNeighborIndex = i;
                }
                break block3;
            }
            for (int i = 0; i < this.searchN; ++i) {
                KdTreeResult r = neighbors.get(i);
                if (!(r.distance > this.mostDistantNeighborSq)) continue;
                throw new RuntimeException("Most distant isn't the most distant");
            }
            KdTreeResult r = neighbors.get(this.mostDistantNeighborIndex);
            r.node = node;
            r.distance = distSq;
            this.mostDistantNeighborSq = -1.0;
            for (int i = 0; i < this.searchN; ++i) {
                r = neighbors.get(i);
                if (!(r.distance > this.mostDistantNeighborSq)) continue;
                this.mostDistantNeighborSq = r.distance;
                this.mostDistantNeighborIndex = i;
            }
        }
    }
}

