/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ArchiveTools {
    private static Map dumpDirs = new HashMap();
    private static final NumberFormat theFormat = NumberFormat.getNumberInstance();

    static {
        theFormat.setMaximumFractionDigits(0);
        theFormat.setMinimumIntegerDigits(19);
        theFormat.setGroupingUsed(false);
    }

    public static String archive(File file, String string, File file2, int n, String string2, String string3, boolean bl, boolean bl2) throws IOException {
        File file3;
        if (n == 0 || file == null) {
            return null;
        }
        String string4 = FileTools.resolvePath(file, string).getAbsolutePath();
        if (!bl2 && string4.equals(file2.getParentFile().getAbsolutePath())) {
            file3 = file2;
        } else {
            DumpDirectory dumpDirectory = DumpDirectory.get(string4);
            file3 = dumpDirectory.getDumpFile(file2.getName(), n);
            if (bl) {
                FileTools.renameFile(file2, string2, file3, string3);
            } else {
                FileTools.copyFile(file2, string2, file3, string3);
            }
        }
        try {
            file3.setLastModified(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file3.getAbsolutePath();
    }

    public static String archive(File file, String string, String string2, InputStream inputStream, int n) throws IOException {
        if (n == 0 || file == null) {
            return null;
        }
        File file2 = ArchiveTools.createArchive(file, string, string2, n);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            try {
                StreamTools.copyStream(inputStream, fileOutputStream);
            }
            catch (Exception exception) {
                throw new IOException("archiving failed (" + exception.getMessage() + ")");
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return file2.getAbsolutePath();
    }

    public static File createArchive(File file, String string, String string2, int n) throws IOException {
        if (n == 0 || file == null) {
            return null;
        }
        String string3 = FileTools.resolvePath(file, string).getAbsolutePath();
        DumpDirectory dumpDirectory = DumpDirectory.get(string3);
        File file2 = dumpDirectory.getDumpFile(string2, n);
        return file2;
    }

    public static OutputStream createOutputStream(File file, String string, int n) throws IOException {
        if (n == 0 || file == null) {
            return null;
        }
        DumpDirectory dumpDirectory = DumpDirectory.get(file);
        File file2 = dumpDirectory.getDumpFile(string, n);
        return new FileOutputStream(file2);
    }

    static class DumpDirectory {
        File dir;
        int currentCount;
        int dirCount;
        long lastDump = System.currentTimeMillis();

        public static DumpDirectory get(File file) {
            return DumpDirectory.get(file.getAbsolutePath());
        }

        public static synchronized DumpDirectory get(String string) {
            DumpDirectory dumpDirectory = (DumpDirectory)dumpDirs.get(string);
            if (dumpDirectory == null) {
                dumpDirectory = new DumpDirectory(new File(string));
                dumpDirectory.prepare();
                dumpDirs.put(string, dumpDirectory);
            }
            return dumpDirectory;
        }

        protected DumpDirectory(File file) {
            this.setDir(file);
        }

        protected void checkDir() throws IOException {
            if (!this.getDir().exists() && !this.getDir().mkdirs()) {
                throw new IOException(" can't create temporary directory " + this.getDir());
            }
        }

        protected void checkFiles(int n) throws IOException {
            if (n <= 0 || this.currentCount <= n) {
                return;
            }
            Object[] objectArray = this.dir.list();
            if (objectArray == null) {
                throw new IOException("can not list directory " + this.dir.getAbsolutePath());
            }
            if (objectArray.length != this.dirCount + this.currentCount) {
                this.prepare((String[])objectArray);
            }
            Arrays.sort(objectArray);
            int n2 = Math.min(objectArray.length, this.currentCount - n);
            int n3 = 0;
            while (n3 < n2) {
                File file = new File(this.dir, (String)objectArray[n3]);
                if (file.isFile()) {
                    if (!file.delete()) {
                        throw new IOException("can not delete file " + file.getAbsolutePath());
                    }
                    --this.currentCount;
                }
                ++n3;
            }
        }

        public File getDir() {
            return this.dir;
        }

        public synchronized File getDumpFile(String string, int n) throws IOException {
            File file = new File(this.getDir(), String.valueOf(this.getUniquePrefix()) + "." + string);
            this.checkDir();
            if (!file.createNewFile()) {
                throw new IOException("can not create file " + file.getAbsolutePath());
            }
            ++this.currentCount;
            try {
                this.checkFiles(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file;
        }

        public long getLastDump() {
            return this.lastDump;
        }

        protected long getUniqueMillis() {
            long l = System.currentTimeMillis();
            while (this.getLastDump() >= l) {
                ++l;
            }
            this.setLastDump(l);
            return l;
        }

        protected String getUniquePrefix() {
            return theFormat.format(this.getUniqueMillis());
        }

        protected void prepare() {
            String[] stringArray = this.dir.list();
            if (stringArray == null) {
                return;
            }
            this.prepare(stringArray);
        }

        protected void prepare(String[] stringArray) {
            this.currentCount = 0;
            this.dirCount = 0;
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    File file = new File(this.dir, stringArray[n]);
                    if (file.isFile()) {
                        ++this.currentCount;
                    } else {
                        ++this.dirCount;
                    }
                    ++n;
                }
            }
        }

        private void setDir(File file) {
            this.dir = file;
        }

        private void setLastDump(long l) {
            this.lastDump = l;
        }
    }
}

