/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.IOException;

public abstract class Loader {
    public static final String PATH_SEPARATOR = "/";
    public static final String DEFAULT_LANGUAGE = "en";
    protected static final String PROP_USERLANGUAGE = "user.language";

    protected abstract boolean basicLoadFile(File var1, boolean var2, String var3) throws IOException;

    public boolean load(File file, boolean bl, boolean bl2) throws IOException {
        if (file == null || !file.exists()) {
            return false;
        }
        return this.basicLoad(file, bl, bl2, "");
    }

    protected boolean basicLoad(File file, boolean bl, boolean bl2, String string) throws IOException {
        if (file.isDirectory()) {
            return this.basicLoadDirectory(file, bl, bl2, string);
        }
        return this.basicLoadFile(file, bl, string);
    }

    protected boolean basicLoadDirectory(File file, boolean bl, boolean bl2, String string) throws IOException {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (bl2) {
                String string2 = string;
                if (file2.isDirectory()) {
                    string2 = String.valueOf(string) + file2.getName() + PATH_SEPARATOR;
                }
                this.basicLoad(file2, bl, bl2, string2);
            } else if (file2.isFile()) {
                this.basicLoadFile(file2, bl, string);
            }
            ++n;
        }
        return true;
    }

    public boolean load(File file, String string, boolean bl, boolean bl2) throws IOException {
        if (string == null) {
            return false;
        }
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(file, string);
        }
        return this.load(file2, bl, bl2);
    }

    public boolean loadNLS(File file, boolean bl, boolean bl2) throws IOException {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            String string = System.getProperty(PROP_USERLANGUAGE);
            File file2 = new File(file, string);
            if (this.load(file2, bl, bl2)) {
                return true;
            }
            File file3 = new File(file, DEFAULT_LANGUAGE);
            return this.load(file3, bl, bl2);
        }
        File file4 = file.getParentFile();
        if (file4 == null) {
            return false;
        }
        String string = FileTools.getBaseName(file);
        String string2 = FileTools.getExtension(file);
        String string3 = System.getProperty(PROP_USERLANGUAGE);
        File file5 = new File(file4, String.valueOf(string) + "_" + string3 + "." + string2);
        if (file.exists() && this.basicLoadFile(file5, bl, "")) {
            return true;
        }
        return this.basicLoadFile(file, bl, "");
    }

    public boolean loadNLS(File file, String string, boolean bl, boolean bl2) throws IOException {
        if (string == null) {
            return false;
        }
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(file, string);
        }
        return this.loadNLS(file2, bl, bl2);
    }
}

