/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;

public class StringMatrixToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -2047404866165517428L;
    protected DataRow m_DataRowType;
    protected SpreadSheet m_SpreadSheetType;
    protected boolean m_ForceString;

    public String globalInfo() {
        return "Converts a string matrix into a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)new DenseDataRow());
        this.m_OptionManager.add("spreadsheet-type", "spreadSheetType", (Object)new SpreadSheet());
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
    }

    public void setDataRowType(DataRow value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRow getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setSpreadSheetType(SpreadSheet value) {
        this.m_SpreadSheetType = value;
        this.reset();
    }

    public SpreadSheet getSpreadSheetType() {
        return this.m_SpreadSheetType;
    }

    public String spreadSheetTypeTipText() {
        return "The type of spreadsheet to use for the data.";
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the value is set as string, even if it resembles a number.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"forceString", (boolean)this.m_ForceString, (String)"force string", (String)"");
    }

    public Class accepts() {
        return String[][].class;
    }

    public Class generates() {
        if (this.m_SpreadSheetType != null) {
            return this.m_SpreadSheetType.getClass();
        }
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        SpreadSheet result = this.m_SpreadSheetType.newInstance();
        result.setDataRowClass(this.m_DataRowType.getClass());
        String[][] matrix = (String[][])this.getInput();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < matrix[0].length; ++i) {
            row.addCell("" + (i + 1)).setContent("col-" + (i + 1));
        }
        for (int n = 0; n < matrix.length; ++n) {
            row = result.addRow("" + (n + 1));
            for (i = 0; i < matrix[0].length; ++i) {
                if (this.m_ForceString) {
                    row.addCell("" + (i + 1)).setContentAsString(matrix[n][i]);
                    continue;
                }
                row.addCell("" + (i + 1)).setContent(matrix[n][i]);
            }
        }
        return result;
    }
}

