/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.rowscore.AbstractMetaRowScore;

public class ColumnSubset
extends AbstractMetaRowScore {
    private static final long serialVersionUID = -9037884201569670797L;
    protected SpreadSheetColumnRange m_Columns;
    protected SpreadSheet m_Header;

    public String globalInfo() {
        return "Applies the specified base row score algorithm to the specified subset of columns and returns the calculated score.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    protected void reset() {
        super.reset();
        this.m_Header = null;
    }

    @Override
    public String rowScoreTipText() {
        return "The row score algorithm to apply to the column subset.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to apply the specified row score algorithm to.";
    }

    protected SpreadSheet createHeader(SpreadSheet sheet) {
        SpreadSheet result = sheet.newInstance();
        this.m_Columns.setData(sheet);
        int[] indices = this.m_Columns.getIntIndices();
        HeaderRow header = result.getHeaderRow();
        for (int index : indices) {
            header.addCell("" + result.getColumnCount()).assign(sheet.getHeaderRow().getCell(index));
        }
        return result;
    }

    protected SpreadSheet createSubset(SpreadSheet sheet, int rowIndex) {
        SpreadSheet result = this.m_Header.getClone();
        int[] indices = this.m_Columns.getIntIndices();
        DataRow rowOld = sheet.getRow(rowIndex);
        DataRow rowNew = result.addRow();
        for (int i = 0; i < indices.length; ++i) {
            rowNew.addCell(i).assign(rowOld.getCell(indices[i]));
        }
        return result;
    }

    @Override
    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = null;
        if (this.m_Header == null) {
            this.m_Header = this.createHeader(sheet);
        }
        SpreadSheet subset = this.createSubset(sheet, rowIndex);
        result = this.m_RowScore.calculateScore(subset, 0);
        return result;
    }
}

