/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;

public class HasRows
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 2973832676958171541L;
    protected int m_NumRows;

    public String globalInfo() {
        return "Checks whether the spreadsheet passing through has a at least the specified number of rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-rows", "numRows", (Object)1, (Number)0, null);
    }

    public void setNumRows(int value) {
        if (value >= 0) {
            this.m_NumRows = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of rows must be at least 0, provided: " + value);
        }
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The minimum number of rows that the spreadsheet needs to have.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"numRows", (Object)this.m_NumRows, (String)"rows: ");
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        SpreadSheet sheet = (SpreadSheet)token.getPayload();
        return sheet.getRowCount() >= this.m_NumRows;
    }
}

