/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.LookUpInit;
import java.util.HashMap;

public class LookUpAdd
extends AbstractTransformer {
    private static final long serialVersionUID = 7602201480653131469L;
    protected StorageName m_StorageName;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Adds a key-value pair to the specified lookup table. \nThe input for the actor a string array of length 2, with the first element the key and the second one the value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are used as value rather than strings.";
    }

    public Class[] accepts() {
        if (this.m_UseNative) {
            return new Class[]{Object[].class};
        }
        return new Class[]{String[].class};
    }

    public Class[] generates() {
        if (this.m_UseNative) {
            return new Class[]{Object.class};
        }
        return new Class[]{String[].class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            HashMap lookup = (HashMap)this.getStorageHandler().getStorage().get(this.m_StorageName);
            Object[] pair = (Object[])this.m_InputToken.getPayload();
            if (pair.length != 2) {
                result = "String array must have length 2, provided: " + pair.length;
            } else {
                String key = pair[0].toString();
                Object value = pair[1];
                if (this.isLoggingEnabled()) {
                    if (lookup.containsKey(key)) {
                        this.getLogger().info("Replacing: '" + key + "' -> '" + value + "'");
                    } else {
                        this.getLogger().info("Adding: '" + key + "' -> '" + value + "'");
                    }
                }
                lookup.put(key, value);
                this.m_OutputToken = this.m_InputToken;
            }
        }
        return result;
    }
}

