/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.AdditionalInformationHandler;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetQueryEditorPanel;
import adams.gui.dialog.TextDialog;
import adams.parser.SpreadSheetQueryText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SpreadSheetQueryPanel
extends BasePanel {
    private static final long serialVersionUID = -4419661519749458767L;
    protected SpreadSheetQueryEditorPanel m_PanelQuery;
    protected JButton m_ButtonOptions;
    protected JButton m_ButtonHelp;
    protected JPanel m_PanelBottom;
    protected JPanel m_PanelButtonsRight;
    protected JPanel m_PanelButtonsLeft;

    protected void initGUI() {
        this.m_PanelQuery = new SpreadSheetQueryEditorPanel();
        this.m_PanelQuery.setWordWrap(true);
        this.add((Component)((Object)this.m_PanelQuery), "Center");
        this.m_PanelBottom = new JPanel(new BorderLayout());
        this.add(this.m_PanelBottom, "South");
        this.m_PanelButtonsLeft = new JPanel(new FlowLayout(0));
        this.m_PanelBottom.add((Component)this.m_PanelButtonsLeft, "West");
        this.m_ButtonOptions = new JButton("...");
        this.m_ButtonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem menuitem = new JMenuItem("Cut");
                menuitem.setIcon(GUIHelper.getIcon((String)"cut.gif"));
                menuitem.setEnabled(SpreadSheetQueryPanel.this.m_PanelQuery.canCut());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.cut();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Copy");
                menuitem.setIcon(GUIHelper.getIcon((String)"copy.gif"));
                menuitem.setEnabled(SpreadSheetQueryPanel.this.m_PanelQuery.canCopy());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.copy();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Paste");
                menuitem.setIcon(GUIHelper.getIcon((String)"paste.gif"));
                menuitem.setEnabled(SpreadSheetQueryPanel.this.m_PanelQuery.canPaste());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.paste();
                    }
                });
                menu.add(menuitem);
                menuitem = new JCheckBoxMenuItem("Line wrap");
                menuitem.setIcon(GUIHelper.getEmptyIcon());
                menuitem.setSelected(SpreadSheetQueryPanel.this.m_PanelQuery.getWordWrap());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.setWordWrap(((JMenuItem)e.getSource()).isSelected());
                    }
                });
                menu.addSeparator();
                menu.add(menuitem);
                menu.show(SpreadSheetQueryPanel.this.m_ButtonOptions, 0, SpreadSheetQueryPanel.this.m_ButtonOptions.getHeight());
            }
        });
        this.m_PanelButtonsLeft.add(this.m_ButtonOptions);
        this.m_PanelButtonsRight = new JPanel(new FlowLayout(2));
        this.m_PanelBottom.add((Component)this.m_PanelButtonsRight, "East");
        if (this.m_PanelQuery instanceof AdditionalInformationHandler) {
            this.m_ButtonHelp = new JButton("Help");
            this.m_ButtonHelp.setMnemonic('H');
            this.m_ButtonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String help = SpreadSheetQueryPanel.this.m_PanelQuery.getAdditionalInformation();
                    TextDialog dlg = new TextDialog();
                    dlg.setDefaultCloseOperation(2);
                    dlg.setDialogTitle("Help");
                    dlg.setContent(help);
                    dlg.setLineWrap(true);
                    dlg.setEditable(false);
                    dlg.setVisible(true);
                }
            });
            this.m_PanelButtonsRight.add(this.m_ButtonHelp);
        }
    }

    public void setQuery(SpreadSheetQueryText value) {
        this.m_PanelQuery.setContent(value.getValue());
    }

    public SpreadSheetQueryText getQuery() {
        return new SpreadSheetQueryText(this.m_PanelQuery.getContent());
    }
}

