/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="http://boofcv.org/index.php?title=Tutorial_Binary_Image", note="Example code taken from this URL")
public class Binary
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = -465068613851000709L;
    protected ThresholdType m_ThresholdType;
    protected float m_Threshold;
    protected int m_GaussianRadius;
    protected int m_SquareRadius;
    protected float m_Bias;
    protected boolean m_ThresholdDown;
    protected boolean m_RemoveSmallBlobs;

    public String globalInfo() {
        return "Creates a binary image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold-type", "thresholdType", (Object)ThresholdType.MANUAL);
        this.m_OptionManager.add("threshold", "threshold", (Object)Float.valueOf(0.0f));
        this.m_OptionManager.add("gaussian-radius", "gaussianRadius", (Object)1, (Number)1, null);
        this.m_OptionManager.add("square-radius", "squareRadius", (Object)1, (Number)1, null);
        this.m_OptionManager.add("bias", "bias", (Object)Float.valueOf(0.0f));
        this.m_OptionManager.add("threshold-down", "thresholdDown", (Object)false);
        this.m_OptionManager.add("remove-small-blobs", "removeSmallBlobs", (Object)false);
    }

    public void setThresholdType(ThresholdType value) {
        this.m_ThresholdType = value;
        this.reset();
    }

    public ThresholdType getThresholdType() {
        return this.m_ThresholdType;
    }

    public String thresholdTypeTipText() {
        return "The type of threshold to apply.";
    }

    public void setThreshold(float value) {
        this.m_Threshold = value;
        this.reset();
    }

    public float getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The manual threshold to use.";
    }

    public void setGaussianRadius(int value) {
        if (value >= 1) {
            this.m_GaussianRadius = value;
            this.reset();
        } else {
            this.getLogger().warning("Gaussian radius must be at least 1, provided: " + value);
        }
    }

    public int getGaussianRadius() {
        return this.m_GaussianRadius;
    }

    public String gaussianRadiusTipText() {
        return "The Gaussian radius to use.";
    }

    public void setSquareRadius(int value) {
        if (value >= 1) {
            this.m_SquareRadius = value;
            this.reset();
        } else {
            this.getLogger().warning("Square radius must be at least 1, provided: " + value);
        }
    }

    public int getSquareRadius() {
        return this.m_SquareRadius;
    }

    public String squareRadiusTipText() {
        return "The radius of the square region to use.";
    }

    public void setBias(float value) {
        this.m_Bias = value;
        this.reset();
    }

    public float getBias() {
        return this.m_Bias;
    }

    public String biasTipText() {
        return "The bias to use (for adaptive methods).";
    }

    public void setThresholdDown(boolean value) {
        this.m_ThresholdDown = value;
        this.reset();
    }

    public boolean getThresholdDown() {
        return this.m_ThresholdDown;
    }

    public String thresholdDownTipText() {
        return "Whether to threshold down or up.";
    }

    public void setRemoveSmallBlobs(boolean value) {
        this.m_RemoveSmallBlobs = value;
        this.reset();
    }

    public boolean getRemoveSmallBlobs() {
        return this.m_RemoveSmallBlobs;
    }

    public String removeSmallBlobsTipText() {
        return "If enabled, small blobs are removed using erode8/dilate8.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ImageUInt8 filtered;
        ImageFloat32 input = (ImageFloat32)BoofCVHelper.toBoofCVImage((ImageBase)img.getImage(), BoofCVImageType.FLOAT_32);
        ImageUInt8 binary = new ImageUInt8(input.width, input.height);
        switch (this.m_ThresholdType) {
            case MANUAL: {
                ThresholdImageOps.threshold((ImageFloat32)input, (ImageUInt8)binary, (float)this.m_Threshold, (boolean)true);
                break;
            }
            case MEAN: {
                double threshold = ImageStatistics.mean((ImageFloat32)input);
                this.getLogger().info("mean: " + threshold);
                ThresholdImageOps.threshold((ImageFloat32)input, (ImageUInt8)binary, (float)((float)threshold), (boolean)true);
                break;
            }
            case ADAPTIVE_GAUSSIAN: {
                ThresholdImageOps.adaptiveGaussian((ImageFloat32)input, (ImageUInt8)binary, (int)this.m_GaussianRadius, (float)this.m_Bias, (boolean)this.m_ThresholdDown, null, null);
                break;
            }
            case ADAPTIVE_SQUARE: {
                ThresholdImageOps.adaptiveSquare((ImageFloat32)input, (ImageUInt8)binary, (int)this.m_SquareRadius, (float)this.m_Bias, (boolean)this.m_ThresholdDown, null, null);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled threshold type: " + (Object)((Object)this.m_ThresholdType));
            }
        }
        if (this.m_RemoveSmallBlobs) {
            filtered = BinaryImageOps.erode8((ImageUInt8)binary, (int)1, null);
            filtered = BinaryImageOps.dilate8((ImageUInt8)filtered, (int)1, null);
        } else {
            filtered = binary;
        }
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)img.getHeader()};
        result[0].setImage(filtered);
        return result;
    }

    public static enum ThresholdType {
        MANUAL,
        MEAN,
        ADAPTIVE_GAUSSIAN,
        ADAPTIVE_SQUARE;

    }
}

