/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;
import java.io.File;

public enum ImageType implements EnumWithCustomDisplay<ImageType>
{
    AUTO("AUTO", "", "Automatic"),
    BMP("BMP", "bmp", "Microsoft Windows bitmap"),
    JPEG("JPEG", "jpg", "Joint Photographic Experts Group JFIF format"),
    PNG("PNG", "png", "Portable Network Graphics"),
    PNM("PNM", "pnm", "Portable anymap"),
    TIFF("TIFF", "tiff", "Tagged Image File Format");

    private String m_Raw = super.toString();
    private String m_Type;
    private String m_Extension;
    private String m_Description;

    private ImageType(String type, String ext, String desc) {
        this.m_Type = type;
        this.m_Extension = ext;
        this.m_Description = desc;
    }

    public String toDisplay() {
        return this.m_Type + " - " + this.m_Description;
    }

    public String toRaw() {
        return this.m_Raw;
    }

    public String toString() {
        return this.toDisplay();
    }

    public String getType() {
        return this.m_Type;
    }

    public String getExtension() {
        return this.m_Extension;
    }

    public boolean matches(File file) {
        return this.matches(file.getPath());
    }

    public boolean matches(String filename) {
        return filename.toLowerCase().endsWith("." + this.m_Extension);
    }

    public ImageType parse(String s) {
        return ImageType.valueOf((AbstractOption)null, s);
    }

    public static String toString(AbstractOption option, Object object) {
        return ((ImageType)((Object)object)).toRaw();
    }

    public static ImageType valueOf(AbstractOption option, String str) {
        ImageType result = null;
        try {
            result = ImageType.valueOf(str);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null) {
            for (ImageType dt : ImageType.values()) {
                if (!dt.toDisplay().equals(str)) continue;
                result = dt;
                break;
            }
        }
        return result;
    }
}

