/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;

public class Brightness
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected float m_Factor;
    protected float m_Offset;

    public String globalInfo() {
        return "Brightens or darkens an image using the specified factor and offset.\nfactor: <0=darken image, >0=brighten image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("factor", "factor", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(1.0E-4f), null);
        this.m_OptionManager.add("offset", "offset", (Object)Float.valueOf(0.0f));
    }

    public void setFactor(float value) {
        if ((double)value > 0.0) {
            this.m_Factor = value;
            this.reset();
        } else {
            this.getLogger().severe("Factor has to be >0, provided: " + value);
        }
    }

    public float getFactor() {
        return this.m_Factor;
    }

    public String factorTipText() {
        return "The factor to use for brightening/darkening.";
    }

    public void setOffset(float value) {
        this.m_Offset = value;
        this.reset();
    }

    public float getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The offset to use for brightening/darkening.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImage image = img.toBufferedImage();
        RescaleOp op = new RescaleOp(this.m_Factor, this.m_Offset, null);
        BufferedImage filtered = op.filter(image, null);
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        result[0].setImage((Object)filtered);
        return result;
    }
}

