/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.normalized;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ConvolveNormalizedStandardSparse {
    public static float convolve(Kernel1D_F32 horizontal, Kernel1D_F32 vertical, ImageFloat32 input, int c_x, int c_y, float[] storage) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        int x0 = c_x - radius;
        int x1 = c_x + radius + 1;
        int y0 = c_y - radius;
        int y1 = c_y + radius + 1;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 > input.width) {
            x1 = input.width;
        }
        if (y1 > input.height) {
            y1 = input.height;
        }
        int startJ = x0 - c_x + radius;
        int endJ = width - (c_x + radius + 1 - x1);
        int indexStorage = y0 - c_y + radius;
        int i = y0;
        while (i < y1) {
            int indexImg = input.startIndex + i * input.stride + x0;
            float total = 0.0f;
            float div = 0.0f;
            int j = startJ;
            while (j < endJ) {
                float kerVal = horizontal.data[j];
                total += input.data[indexImg] * kerVal;
                div += kerVal;
                ++j;
                ++indexImg;
            }
            storage[indexStorage] = total / div;
            ++i;
            ++indexStorage;
        }
        float total = 0.0f;
        float div = 0.0f;
        int endI = width - (c_y + radius + 1 - y1);
        for (int i2 = y0 - c_y + radius; i2 < endI; ++i2) {
            float kerVal = vertical.data[i2];
            total += storage[i2] * kerVal;
            div += kerVal;
        }
        return total / div;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageUInt8 input, int c_x, int c_y, int[] storage) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        int x0 = c_x - radius;
        int x1 = c_x + radius + 1;
        int y0 = c_y - radius;
        int y1 = c_y + radius + 1;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 > input.width) {
            x1 = input.width;
        }
        if (y1 > input.height) {
            y1 = input.height;
        }
        int startJ = x0 - c_x + radius;
        int endJ = width - (c_x + radius + 1 - x1);
        int indexStorage = y0 - c_y + radius;
        int i = y0;
        while (i < y1) {
            int indexImg = input.startIndex + i * input.stride + x0;
            int total = 0;
            int div = 0;
            int j = startJ;
            while (j < endJ) {
                int kerVal = horizontal.data[j];
                total += (input.data[indexImg] & 0xFF) * kerVal;
                div += kerVal;
                ++j;
                ++indexImg;
            }
            storage[indexStorage] = (total + div / 2) / div;
            ++i;
            ++indexStorage;
        }
        int total = 0;
        int div = 0;
        int endI = width - (c_y + radius + 1 - y1);
        for (int i2 = y0 - c_y + radius; i2 < endI; ++i2) {
            int kerVal = vertical.data[i2];
            total += storage[i2] * kerVal;
            div += kerVal;
        }
        return (total + div / 2) / div;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageSInt16 input, int c_x, int c_y, int[] storage) {
        int width = horizontal.getWidth();
        int radius = width / 2;
        int x0 = c_x - radius;
        int x1 = c_x + radius + 1;
        int y0 = c_y - radius;
        int y1 = c_y + radius + 1;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 > input.width) {
            x1 = input.width;
        }
        if (y1 > input.height) {
            y1 = input.height;
        }
        int startJ = x0 - c_x + radius;
        int endJ = width - (c_x + radius + 1 - x1);
        int indexStorage = y0 - c_y + radius;
        int i = y0;
        while (i < y1) {
            int indexImg = input.startIndex + i * input.stride + x0;
            int total = 0;
            int div = 0;
            int j = startJ;
            while (j < endJ) {
                int kerVal = horizontal.data[j];
                total += input.data[indexImg] * kerVal;
                div += kerVal;
                ++j;
                ++indexImg;
            }
            storage[indexStorage] = (total + div / 2) / div;
            ++i;
            ++indexStorage;
        }
        int total = 0;
        int div = 0;
        int endI = width - (c_y + radius + 1 - y1);
        for (int i2 = y0 - c_y + radius; i2 < endI; ++i2) {
            int kerVal = vertical.data[i2];
            total += storage[i2] * kerVal;
            div += kerVal;
        }
        return (total + div / 2) / div;
    }
}

