/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import java.io.Serializable;

public abstract class AbstractGPS
implements Serializable,
Comparable<AbstractGPS>,
Cloneable {
    private static final long serialVersionUID = -9037112025830141712L;
    public static final int NUM_DECIMALS = 6;
    protected Coordinate m_Longitude;
    protected Coordinate m_Latitude;

    public AbstractGPS() {
        this(new Coordinate(), new Coordinate());
    }

    public AbstractGPS(String s) {
        this();
        this.fromString(s);
    }

    public AbstractGPS(String s, boolean swapped) {
        this();
        this.fromString(s, swapped);
    }

    public AbstractGPS(AbstractGPS gps) {
        this(gps.getLatitude().clone(), gps.getLongitude().clone());
    }

    public AbstractGPS(double lat, double lon) {
        this(new Coordinate(lat), new Coordinate(lon));
    }

    public AbstractGPS(Coordinate lat, Coordinate lon) {
        this.m_Longitude = lon;
        this.m_Latitude = lat;
    }

    public Coordinate getLongitude() {
        return this.m_Longitude;
    }

    public Coordinate getLatitude() {
        return this.m_Latitude;
    }

    protected abstract AbstractGPS clone();

    @Override
    public int compareTo(AbstractGPS o) {
        if (o == null) {
            return 1;
        }
        int result = this.m_Latitude.compareTo(o.m_Latitude);
        if (result == 0) {
            result = this.m_Longitude.compareTo(o.m_Longitude);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractGPS) {
            return this.compareTo((AbstractGPS)o) == 0;
        }
        return false;
    }

    protected String preprocess(String s) {
        if (s.startsWith("(") && s.endsWith(")")) {
            return s.replace("(", "").replace(",", "").replace(")", "");
        }
        return s;
    }

    protected abstract Coordinate[] parse(String var1, boolean var2);

    protected Coordinate[] parse(String s) {
        return this.parse(s, false);
    }

    public boolean isValid(String s) {
        return this.parse(s) != null;
    }

    public boolean isValid(String s, boolean swapped) {
        return this.parse(s, swapped) != null;
    }

    public void fromString(String s) {
        if (this.isValid(s)) {
            Coordinate[] coords = this.parse(s);
            this.m_Latitude = coords[0];
            this.m_Longitude = coords[1];
        } else {
            this.m_Latitude = new Coordinate();
            this.m_Longitude = new Coordinate();
        }
    }

    public void fromString(String s, boolean swapped) {
        if (this.isValid(s, swapped)) {
            Coordinate[] coords = this.parse(s, swapped);
            this.m_Latitude = coords[0];
            this.m_Longitude = coords[1];
        } else {
            this.m_Latitude = new Coordinate();
            this.m_Longitude = new Coordinate();
        }
    }

    public abstract String toString();
}

