/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.CloneHandler;
import adams.core.CustomDisplayStringProvider;
import adams.core.ExampleProvider;
import adams.core.HelpProvider;
import java.io.Serializable;

public class Index
implements Serializable,
CustomDisplayStringProvider,
Comparable<Index>,
ExampleProvider,
HelpProvider,
CloneHandler<Index> {
    private static final long serialVersionUID = 4295722716846349301L;
    public static final String FIRST = "first";
    public static final String SECOND = "second";
    public static final String THIRD = "third";
    public static final String LAST_1 = "last_1";
    public static final String LAST_2 = "last_2";
    public static final String LAST = "last";
    protected String m_Raw;
    protected String m_Index;
    protected Integer m_IntIndex;
    protected int m_Max;

    public Index() {
        this("");
    }

    public Index(String index) {
        this(index, -1);
    }

    public Index(String index, int max) {
        this.initialize();
        this.setIndex(index);
        this.setMax(max);
    }

    protected void initialize() {
        this.m_Index = "";
        this.m_IntIndex = -1;
        this.m_Raw = null;
    }

    protected void reset() {
        this.m_IntIndex = null;
    }

    public void setIndex(String value) {
        this.m_Raw = value;
        this.m_Index = null;
        this.reset();
    }

    public synchronized String getIndex() {
        if (this.m_Index == null) {
            this.m_Index = this.clean(this.m_Raw);
        }
        if (this.m_Index.isEmpty()) {
            return this.m_Raw;
        }
        return this.m_Index;
    }

    public void setMax(int value) {
        this.m_Max = value <= 0 ? -1 : value;
        this.reset();
    }

    public int getMax() {
        return this.m_Max;
    }

    public boolean hasIndex() {
        return this.getIndex().length() > 0;
    }

    public boolean isEmpty() {
        return !this.hasIndex();
    }

    @Override
    public Index getClone() {
        Index result;
        try {
            result = (Index)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create new instance of " + this.getClass().getName(), e);
        }
        result.setMax(this.getMax());
        result.setIndex(this.getIndex());
        return result;
    }

    protected boolean isPlaceholder(String s) {
        String tmp = s.toLowerCase();
        if (tmp.equals(FIRST)) {
            return true;
        }
        if (tmp.equals(SECOND)) {
            return true;
        }
        if (tmp.equals(THIRD)) {
            return true;
        }
        if (tmp.equals(LAST_2)) {
            return true;
        }
        if (tmp.equals(LAST_1)) {
            return true;
        }
        return tmp.equals(LAST);
    }

    protected String clean(String s) {
        String result = "";
        String tmp = s.toLowerCase();
        if (this.isPlaceholder(tmp)) {
            result = tmp;
        } else {
            try {
                int num = Integer.parseInt(tmp);
                if (num > 0) {
                    result = tmp;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    protected int parsePlaceholder(String s, int max) {
        if (s.equals(FIRST)) {
            return 0;
        }
        if (s.equals(SECOND)) {
            return 1;
        }
        if (s.equals(THIRD)) {
            return 2;
        }
        if (s.equals(LAST_2)) {
            return max - 3;
        }
        if (s.equals(LAST_1)) {
            return max - 2;
        }
        if (s.equals(LAST)) {
            return max - 1;
        }
        return -1;
    }

    protected int parse(String s, int max) {
        int result = -1;
        if (max > -1) {
            if (this.isPlaceholder(s)) {
                result = this.parsePlaceholder(s, max);
            } else {
                try {
                    result = Integer.parseInt(s) - 1;
                }
                catch (Exception e) {
                    result = -1;
                }
            }
            if (result > max - 1 || result < 0) {
                result = -1;
            }
        } else {
            result = -1;
        }
        return result;
    }

    public int getIntIndex() {
        if (this.m_IntIndex == null) {
            this.m_IntIndex = this.parse(this.getIndex(), this.m_Max);
        }
        return this.m_IntIndex;
    }

    @Override
    public int compareTo(Index o) {
        int result = this.getMax() != -1 && this.getMax() != -1 ? new Integer(this.getIntIndex()).compareTo(new Integer(o.getIntIndex())) : new Integer(this.parse(this.getIndex(), Integer.MAX_VALUE)).compareTo(new Integer(this.parse(o.getIndex(), Integer.MAX_VALUE)));
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Index)) {
            return false;
        }
        return this.compareTo((Index)obj) == 0;
    }

    public int hashCode() {
        return this.getIndex().hashCode();
    }

    public String toString() {
        return "index=" + this.getIndex() + ", max=" + this.m_Max;
    }

    @Override
    public String toDisplay() {
        return this.getIndex();
    }

    @Override
    public String getExample() {
        return "An index is a number starting with 1; the following placeholders can be used as well: first, second, third, last_2, last_1, last";
    }

    @Override
    public String getHelpURL() {
        return null;
    }

    @Override
    public String getHelpDescription() {
        return this.getExample();
    }

    @Override
    public String getHelpTitle() {
        return null;
    }

    @Override
    public String getHelpIcon() {
        return "help2.png";
    }
}

