/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.VariablesInspectionHandler;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionTraverserWithResult;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import java.util.HashSet;

public class VariablesFinder
extends AbstractOptionTraverserWithResult<HashSet<String>> {
    private static final long serialVersionUID = 7547795348352685187L;
    protected HashSet<String> variables;
    protected VariablesInspectionHandler m_Inspection;

    @Override
    public String globalInfo() {
        return "Option traverser for locating variables.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Inspection = new VariablesInspectionHandler(){

            @Override
            public boolean canInspectOptions(Class cls) {
                return true;
            }
        };
    }

    public void setInspection(VariablesInspectionHandler value) {
        this.m_Inspection = value;
    }

    @Override
    public void resetResult() {
        this.variables = new HashSet();
    }

    @Override
    public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
        this.handleArgumentOption(option, path);
    }

    @Override
    public void handleClassOption(ClassOption option, OptionTraversalPath path) {
        this.handleArgumentOption(option, path);
    }

    @Override
    public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
        if (option.isVariableAttached() && !this.isSkipped(option)) {
            this.variables.add(option.getVariableName());
        }
    }

    @Override
    public boolean canHandle(AbstractOption option) {
        return true;
    }

    @Override
    public boolean canRecurse(Class cls) {
        return this.m_Inspection.canInspectOptions(cls);
    }

    @Override
    public boolean canRecurse(Object obj) {
        return this.canRecurse(obj.getClass());
    }

    protected boolean isSkipped(AbstractOption option) {
        return false;
    }

    @Override
    public HashSet<String> getResult() {
        return this.variables;
    }
}

