/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.Utils;
import adams.core.base.AbstractBaseString;
import java.awt.geom.Point2D;

public class BasePointFloat
extends AbstractBaseString {
    private static final long serialVersionUID = -3504062141216626521L;
    public static final String SEPARATOR = ";";
    public static final String DEFAULT = "0;0";

    public BasePointFloat() {
        this(DEFAULT);
    }

    public BasePointFloat(String s) {
        super(s);
    }

    public BasePointFloat(Point2D.Float value) {
        this(BasePointFloat.toString(value));
    }

    public BasePointFloat(Float x, Float y) {
        this(new Point2D.Float(x.floatValue(), y.floatValue()));
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        return this.parse(value) != null;
    }

    public Point2D.Float pointValue() {
        return this.parse((String)((Object)this.m_Internal));
    }

    @Override
    public String getTipText() {
        return "An float point (x;y).";
    }

    public static String toString(Point2D.Float d) {
        return d.x + SEPARATOR + d.y;
    }

    public Point2D.Float parse(String s) {
        String[] parts;
        Point2D.Float result = null;
        if (s.indexOf(SEPARATOR) > 0 && (parts = s.split(SEPARATOR)).length == 2 && Utils.isFloat(parts[0]) && Utils.isFloat(parts[1])) {
            result = new Point2D.Float(Float.parseFloat(parts[0]), Float.parseFloat(parts[1]));
        }
        return result;
    }
}

