/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.Utils;
import adams.core.base.AbstractBaseString;
import java.util.regex.Pattern;

public class BaseRegExp
extends AbstractBaseString {
    private static final long serialVersionUID = -8687858764646783666L;
    public static final String MATCH_ALL = ".*";
    protected Pattern m_Pattern;

    public BaseRegExp() {
        this(MATCH_ALL);
    }

    public BaseRegExp(String s) {
        super(s);
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            Pattern.compile(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected String convert(String value) {
        this.m_Pattern = Pattern.compile(value);
        return super.convert(value);
    }

    @Override
    public String stringValue() {
        return Utils.backQuoteChars(this.getValue());
    }

    @Override
    public String getTipText() {
        return "Regular expression.";
    }

    public boolean isMatch(String s) {
        return this.m_Pattern.matcher(s).matches();
    }

    public boolean isMatchAll() {
        return this.getValue().equals(MATCH_ALL);
    }

    @Override
    public boolean isEmpty() {
        return this.getValue().length() == 0;
    }
}

