/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.HelpProvider;
import adams.core.base.AbstractBaseString;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;

public class JsonPathExpression
extends AbstractBaseString
implements HelpProvider {
    private static final long serialVersionUID = -6084976027405972444L;

    public JsonPathExpression() {
    }

    public JsonPathExpression(String s) {
        super(s);
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0 || !value.startsWith("$")) {
            return true;
        }
        try {
            JsonPath.compile((String)value, (Filter[])new Filter[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSimpleKey() {
        return !this.getValue().startsWith("$");
    }

    public JsonPath toJsonPath() {
        try {
            return JsonPath.compile((String)this.getValue(), (Filter[])new Filter[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getTipText() {
        return "JSON Path expression (interpreted as path if starts with '$', otherwise simple key)";
    }

    @Override
    public String getHelpURL() {
        return "http://code.google.com/p/json-path/";
    }

    @Override
    public String getHelpDescription() {
        return "More information on JSON Path";
    }

    @Override
    public String getHelpTitle() {
        return null;
    }

    @Override
    public String getHelpIcon() {
        return "help2.png";
    }
}

